/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedNamePatternJvmSystemPropertyTest
extends ManagementTestSupport {
    @Override
    protected void setUp() throws Exception {
        System.setProperty("org.apache.camel.jmx.managementNamePattern", "cool-#name#");
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        System.clearProperty("org.apache.camel.jmx.managementNamePattern");
        super.tearDown();
    }

    public void testManagedNamePattern() throws Exception {
        if (ManagedNamePatternJvmSystemPropertyTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ManagedNamePatternJvmSystemPropertyTest.assertEquals((String)"cool-camel-1", (String)this.context.getManagementName());
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=cool-camel-1,type=context,name=\"camel-1\"");
        ManagedNamePatternJvmSystemPropertyTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

