/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.StringHelper;

public class ManagedCamelContextTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementNameStrategy().setNamePattern("19-#name#");
        return context;
    }

    public void testManagedCamelContext() throws Exception {
        if (ManagedCamelContextTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=context,name=\"camel-1\"");
        ManagedCamelContextTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        String name = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedCamelContextTest.assertEquals((String)"camel-1", (String)name);
        String managementName = (String)mbeanServer.getAttribute(on, "ManagementName");
        ManagedCamelContextTest.assertEquals((String)"19-camel-1", (String)managementName);
        String uptime = (String)mbeanServer.getAttribute(on, "Uptime");
        ManagedCamelContextTest.assertNotNull((Object)uptime);
        String status = (String)mbeanServer.getAttribute(on, "State");
        ManagedCamelContextTest.assertEquals((String)"Started", (String)status);
        Boolean messageHistory = (Boolean)mbeanServer.getAttribute(on, "MessageHistory");
        ManagedCamelContextTest.assertEquals((Object)Boolean.TRUE, (Object)messageHistory);
        Integer total = (Integer)mbeanServer.getAttribute(on, "TotalRoutes");
        ManagedCamelContextTest.assertEquals((int)2, (int)total);
        Integer started = (Integer)mbeanServer.getAttribute(on, "StartedRoutes");
        ManagedCamelContextTest.assertEquals((int)2, (int)started);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mbeanServer.invoke(on, "sendBody", new Object[]{"direct:start", "Hello World"}, new String[]{"java.lang.String", "java.lang.Object"});
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mbeanServer.invoke(on, "sendStringBody", new Object[]{"direct:start", "Hello World"}, new String[]{"java.lang.String", "java.lang.String"});
        this.assertMockEndpointsSatisfied();
        Object reply = mbeanServer.invoke(on, "requestBody", new Object[]{"direct:foo", "Hello World"}, new String[]{"java.lang.String", "java.lang.Object"});
        ManagedCamelContextTest.assertEquals((Object)"Bye World", (Object)reply);
        reply = mbeanServer.invoke(on, "requestStringBody", new Object[]{"direct:foo", "Hello World"}, new String[]{"java.lang.String", "java.lang.String"});
        ManagedCamelContextTest.assertEquals((Object)"Bye World", (Object)reply);
        this.resetMocks();
        mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("foo", (Object)123);
        HashMap<String, Integer> headers = new HashMap<String, Integer>();
        headers.put("foo", 123);
        mbeanServer.invoke(on, "sendBodyAndHeaders", new Object[]{"direct:start", "Hello World", headers}, new String[]{"java.lang.String", "java.lang.Object", "java.util.Map"});
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("foo", (Object)123);
        reply = mbeanServer.invoke(on, "requestBodyAndHeaders", new Object[]{"direct:start", "Hello World", headers}, new String[]{"java.lang.String", "java.lang.Object", "java.util.Map"});
        ManagedCamelContextTest.assertEquals((Object)"Hello World", (Object)reply);
        this.assertMockEndpointsSatisfied();
        Boolean can = (Boolean)mbeanServer.invoke(on, "canSendToEndpoint", new Object[]{"direct:start"}, new String[]{"java.lang.String"});
        ManagedCamelContextTest.assertEquals((boolean)true, (boolean)can);
        can = (Boolean)mbeanServer.invoke(on, "canSendToEndpoint", new Object[]{"timer:foo"}, new String[]{"java.lang.String"});
        ManagedCamelContextTest.assertEquals((boolean)false, (boolean)can);
        mbeanServer.invoke(on, "stop", null, null);
    }

    public void testManagedCamelContextCreateEndpoint() throws Exception {
        if (ManagedCamelContextTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=context,name=\"camel-1\"");
        ManagedCamelContextTest.assertNull((Object)this.context.hasEndpoint("seda:bar"));
        Object reply = mbeanServer.invoke(on, "createEndpoint", new Object[]{"seda:bar"}, new String[]{"java.lang.String"});
        ManagedCamelContextTest.assertEquals((Object)Boolean.TRUE, (Object)reply);
        ManagedCamelContextTest.assertNotNull((Object)this.context.hasEndpoint("seda:bar"));
        ObjectName seda = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=endpoints,name=\"seda://bar\"");
        boolean registered = mbeanServer.isRegistered(seda);
        ManagedCamelContextTest.assertTrue((String)("Should be registered " + seda), (boolean)registered);
        reply = mbeanServer.invoke(on, "createEndpoint", new Object[]{"seda:bar"}, new String[]{"java.lang.String"});
        ManagedCamelContextTest.assertEquals((Object)Boolean.FALSE, (Object)reply);
        registered = mbeanServer.isRegistered(seda);
        ManagedCamelContextTest.assertTrue((String)("Should be registered " + seda), (boolean)registered);
    }

    public void testManagedCamelContextRemoveEndpoint() throws Exception {
        if (ManagedCamelContextTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=context,name=\"camel-1\"");
        ManagedCamelContextTest.assertNull((Object)this.context.hasEndpoint("seda:bar"));
        Object reply = mbeanServer.invoke(on, "createEndpoint", new Object[]{"seda:bar"}, new String[]{"java.lang.String"});
        ManagedCamelContextTest.assertEquals((Object)Boolean.TRUE, (Object)reply);
        ManagedCamelContextTest.assertNotNull((Object)this.context.hasEndpoint("seda:bar"));
        ObjectName seda = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=endpoints,name=\"seda://bar\"");
        boolean registered = mbeanServer.isRegistered(seda);
        ManagedCamelContextTest.assertTrue((String)("Should be registered " + seda), (boolean)registered);
        Object num = mbeanServer.invoke(on, "removeEndpoints", new Object[]{"seda:*"}, new String[]{"java.lang.String"});
        ManagedCamelContextTest.assertEquals((Object)1, (Object)num);
        ManagedCamelContextTest.assertNull((Object)this.context.hasEndpoint("seda:bar"));
        registered = mbeanServer.isRegistered(seda);
        ManagedCamelContextTest.assertFalse((String)("Should not be registered " + seda), (boolean)registered);
        num = mbeanServer.invoke(on, "removeEndpoints", new Object[]{"seda:*"}, new String[]{"java.lang.String"});
        ManagedCamelContextTest.assertEquals((Object)0, (Object)num);
        ManagedCamelContextTest.assertNull((Object)this.context.hasEndpoint("seda:bar"));
        registered = mbeanServer.isRegistered(seda);
        ManagedCamelContextTest.assertFalse((String)("Should not be registered " + seda), (boolean)registered);
    }

    public void testFindComponentsInClasspath() throws Exception {
        if (ManagedCamelContextTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=context,name=\"camel-1\"");
        ManagedCamelContextTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        Map info = (Map)mbeanServer.invoke(on, "findComponents", null, null);
        ManagedCamelContextTest.assertNotNull((Object)info);
        ManagedCamelContextTest.assertTrue((info.size() > 20 ? 1 : 0) != 0);
        Properties prop = (Properties)info.get("seda");
        ManagedCamelContextTest.assertNotNull((Object)prop);
        ManagedCamelContextTest.assertEquals((Object)"seda", (Object)prop.get("name"));
        ManagedCamelContextTest.assertEquals((Object)"org.apache.camel", (Object)prop.get("groupId"));
        ManagedCamelContextTest.assertEquals((Object)"camel-core", (Object)prop.get("artifactId"));
    }

    public void testManagedCamelContextCreateRouteStaticEndpointJson() throws Exception {
        if (ManagedCamelContextTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=context,name=\"camel-1\"");
        String json = (String)mbeanServer.invoke(on, "createRouteStaticEndpointJson", null, null);
        ManagedCamelContextTest.assertNotNull((Object)json);
        ManagedCamelContextTest.assertEquals((int)7, (int)StringHelper.countChar((String)json, (char)'{'));
        ManagedCamelContextTest.assertEquals((int)7, (int)StringHelper.countChar((String)json, (char)'}'));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("{ \"uri\": \"direct://start\" }"));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("{ \"uri\": \"direct://foo\" }"));
    }

    public void testManagedCamelContextExplainEndpointUriFalse() throws Exception {
        if (ManagedCamelContextTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=context,name=\"camel-1\"");
        String json = (String)mbeanServer.invoke(on, "explainEndpointJson", new Object[]{"log:foo?groupDelay=2000&groupSize=5", false}, new String[]{"java.lang.String", "boolean"});
        ManagedCamelContextTest.assertNotNull((Object)json);
        int pos = json.indexOf("loggerName");
        int pos2 = json.indexOf("groupDelay");
        ManagedCamelContextTest.assertTrue((String)"LoggerName should come before groupDelay", (pos < pos2 ? 1 : 0) != 0);
        ManagedCamelContextTest.assertEquals((int)8, (int)StringHelper.countChar((String)json, (char)'{'));
        ManagedCamelContextTest.assertEquals((int)8, (int)StringHelper.countChar((String)json, (char)'}'));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"scheme\": \"log\""));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"label\": \"core,monitoring\""));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"groupDelay\": { \"kind\": \"parameter\", \"type\": \"integer\", \"javaType\": \"java.lang.Long\", \"deprecated\": \"false\", \"value\": \"2000\", \"description\": \"Set the initial delay for stats (in millis)\" }"));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"groupSize\": { \"kind\": \"parameter\", \"type\": \"integer\", \"javaType\": \"java.lang.Integer\", \"deprecated\": \"false\", \"value\": \"5\", \"description\": \"An integer that specifies a group size for throughput logging.\" }"));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"loggerName\": { \"kind\": \"path\", \"required\": \"true\", \"type\": \"string\", \"javaType\": \"java.lang.String\", \"deprecated\": \"false\", \"value\": \"foo\", \"description\": \"The logger name to use\" }"));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("Set the initial delay for stats (in millis)"));
    }

    public void testManagedCamelContextExplainEndpointUriTrue() throws Exception {
        if (ManagedCamelContextTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=context,name=\"camel-1\"");
        String json = (String)mbeanServer.invoke(on, "explainEndpointJson", new Object[]{"log:foo?groupDelay=2000&groupSize=5", true}, new String[]{"java.lang.String", "boolean"});
        ManagedCamelContextTest.assertNotNull((Object)json);
        int pos = json.indexOf("loggerName");
        int pos2 = json.indexOf("groupDelay");
        ManagedCamelContextTest.assertTrue((String)"LoggerName should come before groupDelay", (pos < pos2 ? 1 : 0) != 0);
        ManagedCamelContextTest.assertEquals((int)14, (int)StringHelper.countChar((String)json, (char)'{'));
        ManagedCamelContextTest.assertEquals((int)14, (int)StringHelper.countChar((String)json, (char)'}'));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"scheme\": \"log\""));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"label\": \"core,monitoring\""));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"groupDelay\": { \"kind\": \"parameter\", \"type\": \"integer\", \"javaType\": \"java.lang.Long\", \"deprecated\": \"false\", \"value\": \"2000\", \"description\": \"Set the initial delay for stats (in millis)\" }"));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"groupSize\": { \"kind\": \"parameter\", \"type\": \"integer\", \"javaType\": \"java.lang.Integer\", \"deprecated\": \"false\", \"value\": \"5\", \"description\": \"An integer that specifies a group size for throughput logging.\" }"));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"loggerName\": { \"kind\": \"path\", \"required\": \"true\", \"type\": \"string\", \"javaType\": \"java.lang.String\", \"deprecated\": \"false\", \"value\": \"foo\", \"description\": \"The logger name to use\" }"));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"marker\": { \"kind\": \"parameter\", \"type\": \"string\", \"javaType\": \"java.lang.String\""));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("Set the initial delay for stats (in millis)"));
    }

    public void testManagedCamelContextExplainEipFalse() throws Exception {
        if (ManagedCamelContextTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=context,name=\"camel-1\"");
        String json = (String)mbeanServer.invoke(on, "explainEipJson", new Object[]{"myTransform", false}, new String[]{"java.lang.String", "boolean"});
        ManagedCamelContextTest.assertNotNull((Object)json);
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"label\": \"eip,transformation\""));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"expression\": { \"kind\": \"expression\", \"required\": \"true\", \"type\": \"object\""));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("Bye World"));
    }

    public void testManagedCamelContextExplainEipTrue() throws Exception {
        if (ManagedCamelContextTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=context,name=\"camel-1\"");
        String json = (String)mbeanServer.invoke(on, "explainEipJson", new Object[]{"myTransform", true}, new String[]{"java.lang.String", "boolean"});
        ManagedCamelContextTest.assertNotNull((Object)json);
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"label\": \"eip,transformation\""));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"expression\": { \"kind\": \"expression\", \"required\": \"true\", \"type\": \"object\""));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"description\": { \"kind\": \"element\", \"required\": \"false\", \"type\": \"object\", \"javaType\""));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("Bye World"));
    }

    public void testManagedCamelContextExplainEipModel() throws Exception {
        if (ManagedCamelContextTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=context,name=\"camel-1\"");
        String json = (String)mbeanServer.invoke(on, "explainEipJson", new Object[]{"aggregate", false}, new String[]{"java.lang.String", "boolean"});
        ManagedCamelContextTest.assertNotNull((Object)json);
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"description\": \"Aggregates many messages into a single message\""));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"label\": \"eip,routing\""));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"correlationExpression\": { \"kind\": \"expression\", \"required\": \"true\", \"type\": \"object\""));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"discardOnCompletionTimeout\": { \"kind\": \"attribute\", \"required\": \"false\", \"type\": \"boolean\""));
    }

    public void testManagedCamelContextExplainComponentModel() throws Exception {
        if (ManagedCamelContextTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=19-camel-1,type=context,name=\"camel-1\"");
        String json = (String)mbeanServer.invoke(on, "explainComponentJson", new Object[]{"seda", false}, new String[]{"java.lang.String", "boolean"});
        ManagedCamelContextTest.assertNotNull((Object)json);
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"label\": \"core,endpoint\""));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"defaultQueueFactory\": { \"kind\": \"property\", \"type\": \"object\", \"javaType\": \"org.apache.camel.component.seda.BlockingQueueFactory<org.apache.camel.Exchange>\","));
        ManagedCamelContextTest.assertTrue((boolean)json.contains("\"queueSize\": { \"kind\": \"property\", \"type\": \"integer\", \"javaType\": \"int\", \"deprecated\": \"false\", \"value\": \"0\""));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
                ((RouteDefinition)this.from("direct:foo").transform((Expression)this.constant("Bye World"))).id("myTransform");
            }
        };
    }
}

