/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.EventObject;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;

public class ManagedCamelContextRestartTest
extends ManagementTestSupport {
    private int starts;
    private int stops;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(EventObject event) throws Exception {
            }

            public boolean isEnabled(EventObject event) {
                return true;
            }

            protected void doStart() throws Exception {
                ManagedCamelContextRestartTest.this.starts++;
            }

            protected void doStop() throws Exception {
                ManagedCamelContextRestartTest.this.stops++;
            }
        });
    }

    public void testManagedCamelContext() throws Exception {
        if (ManagedCamelContextRestartTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        ManagedCamelContextRestartTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        String name = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedCamelContextRestartTest.assertEquals((String)"camel-1", (String)name);
        String uptime = (String)mbeanServer.getAttribute(on, "Uptime");
        ManagedCamelContextRestartTest.assertNotNull((Object)uptime);
        String status = (String)mbeanServer.getAttribute(on, "State");
        ManagedCamelContextRestartTest.assertEquals((String)"Started", (String)status);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        Object reply = mbeanServer.invoke(on, "requestBody", new Object[]{"direct:foo", "Hello World"}, new String[]{"java.lang.String", "java.lang.Object"});
        ManagedCamelContextRestartTest.assertEquals((Object)"Bye World", (Object)reply);
        ManagedCamelContextRestartTest.assertEquals((int)0, (int)this.starts);
        ManagedCamelContextRestartTest.assertEquals((int)0, (int)this.stops);
        mbeanServer.invoke(on, "restart", null, null);
        ManagedCamelContextRestartTest.assertEquals((int)1, (int)this.starts);
        ManagedCamelContextRestartTest.assertEquals((int)1, (int)this.stops);
        status = (String)mbeanServer.getAttribute(on, "State");
        ManagedCamelContextRestartTest.assertEquals((String)"Started", (String)status);
        reply = mbeanServer.invoke(on, "requestBody", new Object[]{"direct:foo", "Hello Camel"}, new String[]{"java.lang.String", "java.lang.Object"});
        ManagedCamelContextRestartTest.assertEquals((Object)"Bye World", (Object)reply);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo").transform((Expression)this.constant("Bye World"));
            }
        };
    }
}

