/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.TimerListener;
import org.apache.camel.management.mbean.LoadTriplet;
import org.apache.camel.support.TimerListenerManager;

public class LoadTimerTest
extends ContextTestSupport {
    private static final int SAMPLES = 3;

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimer() throws Exception {
        TimerListenerManager myTimer = new TimerListenerManager();
        myTimer.setCamelContext((CamelContext)this.context);
        myTimer.start();
        TestLoadAware test = new TestLoadAware();
        myTimer.addTimerListener((TimerListener)test);
        try {
            Thread.sleep(4000L);
            LoadTimerTest.assertTrue((test.counter >= 3 ? 1 : 0) != 0);
            LoadTimerTest.assertFalse((boolean)Double.isNaN(test.load.getLoad1()));
            LoadTimerTest.assertTrue((test.load.getLoad1() > 0.0 ? 1 : 0) != 0);
            LoadTimerTest.assertTrue((test.load.getLoad1() < 3.0 ? 1 : 0) != 0);
        }
        finally {
            myTimer.removeTimerListener((TimerListener)test);
        }
        myTimer.stop();
    }

    private class TestLoadAware
    implements TimerListener {
        int counter;
        LoadTriplet load = new LoadTriplet();

        private TestLoadAware() {
        }

        public void onTimer() {
            ++this.counter;
            this.load.update(this.counter);
        }
    }
}

