/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;

public class AddEventNotifierTest
extends ContextTestSupport {
    private static List<EventObject> events = new ArrayList<EventObject>();
    private EventNotifier notifier;

    @Override
    public void setUp() throws Exception {
        events.clear();
        super.setUp();
    }

    public void testAddAndRemove() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        AddEventNotifierTest.assertEquals((int)0, (int)events.size());
        this.notifier = new EventNotifierSupport(){

            public void notify(EventObject event) throws Exception {
                events.add(event);
            }

            public boolean isEnabled(EventObject event) {
                return true;
            }

            protected void doStart() throws Exception {
            }

            protected void doStop() throws Exception {
            }
        };
        this.context.addService((Object)this.notifier);
        this.context.getManagementStrategy().addEventNotifier(this.notifier);
        this.resetMocks();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        AddEventNotifierTest.assertEquals((int)8, (int)events.size());
        this.context.getManagementStrategy().removeEventNotifier(this.notifier);
        this.resetMocks();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hi World");
        this.assertMockEndpointsSatisfied();
        AddEventNotifierTest.assertEquals((int)8, (int)events.size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

