/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.ProcessorDefinition;

public class SimplePropertiesNestedTest
extends ContextTestSupport {
    public void testSimplePropertiesNested() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("myHeader", (Object)"Beer taste good");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "beer", (Object)"bar.quote");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ProcessorDefinition)this.from("direct:start").setHeader("myHeader").simple("${properties:${header.beer}}")).to("mock:result");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = new PropertiesComponent();
        pc.setCamelContext(context);
        pc.setLocations(new String[]{"org/apache/camel/component/properties/bar.properties"});
        context.addComponent("properties", (Component)pc);
        return context;
    }
}

