/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.LanguageTestSupport;
import org.apache.camel.language.simple.SimpleLanguage;

public class SimpleChangeFunctionTokensTest
extends LanguageTestSupport {
    @Override
    protected String getLanguageName() {
        return "simple";
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        SimpleLanguage.changeFunctionStartToken((String[])new String[]{"[["});
        SimpleLanguage.changeFunctionEndToken((String[])new String[]{"]]"});
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        SimpleLanguage.changeFunctionStartToken((String[])new String[]{"${", "$simple{"});
        SimpleLanguage.changeFunctionEndToken((String[])new String[]{"}"});
    }

    public void testSimpleBody() throws Exception {
        this.assertExpression(this.exchange, "[[body]]", (Object)"<hello id='m123'>world!</hello>");
        this.assertExpression(this.exchange, "${body}", (Object)"${body}");
    }

    public void testSimpleConstantAndBody() throws Exception {
        this.exchange.getIn().setBody((Object)"Camel");
        this.assertExpression(this.exchange, "Hi [[body]] how are you", (Object)"Hi Camel how are you");
        this.assertExpression(this.exchange, "'Hi '[[body]]' how are you'", (Object)"'Hi 'Camel' how are you'");
        this.assertExpression(this.exchange, "Hi ${body} how are you", (Object)"Hi ${body} how are you");
    }

    public void testSimpleConstantAndBodyAndHeader() throws Exception {
        this.exchange.getIn().setBody((Object)"Camel");
        this.exchange.getIn().setHeader("foo", (Object)"Tiger");
        this.assertExpression(this.exchange, "Hi [[body]] how are [[header.foo]]", (Object)"Hi Camel how are Tiger");
    }

    public void testSimpleEqOperator() throws Exception {
        this.exchange.getIn().setBody((Object)"Camel");
        this.assertPredicate(this.exchange, "[[body]] == 'Tiger'", false);
        this.assertPredicate(this.exchange, "[[body]] == 'Camel'", true);
        this.assertPredicate(this.exchange, "[[body]] == \"Tiger\"", false);
        this.assertPredicate(this.exchange, "[[body]] == \"Camel\"", true);
    }
}

