/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OnExceptionDefinition;

public class XPathFromFileExceptionTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        XPathFromFileExceptionTest.deleteDirectory("target/xpath");
        super.setUp();
    }

    public void testXPathFromFileExceptionOk() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.template.sendBodyAndHeader("file:target/xpath", (Object)"<hello>world!</hello>", "CamelFileName", (Object)"hello.xml");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        File file = new File("target/xpath/hello.xml");
        XPathFromFileExceptionTest.assertFalse((String)("File should not exists " + file), (boolean)file.exists());
        file = new File("target/xpath/ok/hello.xml");
        XPathFromFileExceptionTest.assertTrue((String)("File should exists " + file), (boolean)file.exists());
    }

    public void testXPathFromFileExceptionFail() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.template.sendBodyAndHeader("file:target/xpath", (Object)"<hello>world!</hello", "CamelFileName", (Object)"hello2.xml");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        File file = new File("target/xpath/hello2.xml");
        XPathFromFileExceptionTest.assertFalse((String)("File should not exists " + file), (boolean)file.exists());
        file = new File("target/xpath/error/hello2.xml");
        XPathFromFileExceptionTest.assertTrue((String)("File should exists " + file), (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((OnExceptionDefinition)this.from("file:target/xpath?moveFailed=error&move=ok").onException(Exception.class).to("mock:error")).end().choice().when().xpath("/hello")).to("mock:result")).end();
            }
        };
    }
}

