/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.ProcessorDefinition;

public class BeanLanguageOGNLWithDotInParameterPropertyPlaceholderTest
extends ContextTestSupport {
    private Properties myProp;

    public void testDot() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("goto", (Object)"mock:MyAppV1.2.3/blah");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "id", (Object)"blah");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myBean", (Object)new MyDestinationBean());
        this.myProp = new Properties();
        this.myProp.put("myApp", "MyAppV1.2.3");
        jndi.bind("myprop", (Object)this.myProp);
        return jndi;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = (PropertiesComponent)context.getComponent("properties", PropertiesComponent.class);
        pc.setLocation("ref:myprop");
        return context;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ProcessorDefinition)this.from("direct:start").setHeader("goto").simple("${bean:myBean.whereToMate({{myApp}}, ${header.id})}")).to("mock:result");
            }
        };
    }

    public static class MyDestinationBean {
        public String whereToMate(String version, String id) {
            return "mock:" + version + "/" + id;
        }
    }
}

