/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.SplitDefinition;

public class SplitterUsingBeanReturningMessageTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("mySplitter", (Object)new MyOtherSplitterBean());
        return jndi;
    }

    public void testSplitWithMessage() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).body()).isEqualTo((Object)"not empty");
        ((ValueBuilder)mock.message(0).header("type")).isEqualTo((Object)"TYPE1");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((SplitDefinition)this.from("direct:start").split().method("mySplitter")).to(new String[]{"log:foo", "mock:result"});
            }
        };
    }

    public static class MyOtherSplitterBean {
        public List<?> split(Exchange exchange) {
            Message in = exchange.getIn();
            TestCase.assertNotNull((Object)in.toString());
            LinkedList<Message> msgs = new LinkedList<Message>();
            Message copy = in.copy();
            TestCase.assertNotNull((Object)copy.toString());
            copy.setBody((Object)"not empty");
            copy.setHeader("type", (Object)"TYPE1");
            msgs.add(copy);
            return msgs;
        }
    }
}

