/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.RouteDefinition;

public class StartAndStopRoutesTest
extends ContextTestSupport {
    protected SedaEndpoint endpointA;
    protected SedaEndpoint endpointB;
    protected SedaEndpoint endpointC;
    protected Object expectedBody = "<hello>world!</hello>";

    public void testStartRouteThenStopMutateAndStartRouteAgain() throws Exception {
        List routes = this.context.getRouteDefinitions();
        StartAndStopRoutesTest.assertCollectionSize("Route", routes, 1);
        RouteDefinition route = (RouteDefinition)routes.get(0);
        this.endpointA = this.getMandatoryEndpoint("seda:test.a", SedaEndpoint.class);
        this.endpointB = this.getMandatoryEndpoint("seda:test.b", SedaEndpoint.class);
        this.endpointC = this.getMandatoryEndpoint("seda:test.C", SedaEndpoint.class);
        MockEndpoint results = this.getMockEndpoint("mock:results");
        results.expectedBodiesReceived(new Object[]{this.expectedBody});
        this.template.sendBody((Endpoint)this.endpointA, this.expectedBody);
        this.assertMockEndpointsSatisfied();
        this.context.stopRoute(route);
        FromDefinition fromType = (FromDefinition)StartAndStopRoutesTest.assertOneElement(route.getInputs());
        fromType.setUri("seda:test.C");
        this.context.startRoute(route);
        results.reset();
        results = this.getMockEndpoint("mock:results");
        results.expectedBodiesReceived(new Object[]{this.expectedBody});
        this.template.sendBody((Endpoint)this.endpointC, this.expectedBody);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:test.a").to("seda:test.b")).to("mock:results");
            }
        };
    }
}

