/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class ShutdownRouteGracefulTimeoutTriggerTest
extends ContextTestSupport {
    private static String foo = "";

    public void testShutdownRouteGraceful() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"A");
        this.template.sendBody("seda:foo", (Object)"B");
        this.template.sendBody("seda:foo", (Object)"C");
        this.template.sendBody("seda:foo", (Object)"D");
        this.template.sendBody("seda:foo", (Object)"E");
        this.assertMockEndpointsSatisfied();
        foo = foo + "stop";
        this.context.shutdownRoute("seda", 2L, TimeUnit.SECONDS);
        ShutdownRouteGracefulTimeoutTriggerTest.assertNotSame((String)"Should not able able to complete all pending messages", (Object)"stopABCDE", (Object)foo);
        ShutdownRouteGracefulTimeoutTriggerTest.assertEquals((String)"bar should still be running", (boolean)true, (boolean)this.context.getRouteStatus("bar").isStarted());
        ShutdownRouteGracefulTimeoutTriggerTest.assertEquals((String)"Seda should be stopped", (boolean)true, (boolean)this.context.getRouteStatus("seda").isStopped());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:foo").routeId("seda").to("mock:foo")).delay(1000L).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        foo = foo + (String)exchange.getIn().getBody(String.class);
                    }
                });
                this.from("direct:bar").routeId("bar").to("mock:bar");
            }
        };
    }
}

