/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.impl.ThreadPoolProfileSupport;
import org.apache.camel.spi.ThreadPoolProfile;

public class DefaultExecutorServiceStrategyTest
extends ContextTestSupport {
    public void testGetThreadNameDefaultPattern() throws Exception {
        String foo = this.context.getExecutorServiceStrategy().getThreadName("foo");
        String bar = this.context.getExecutorServiceStrategy().getThreadName("bar");
        DefaultExecutorServiceStrategyTest.assertNotSame((Object)foo, (Object)bar);
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)foo.startsWith("Camel (" + this.context.getName() + ") thread "));
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)foo.endsWith("foo"));
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)bar.startsWith("Camel (" + this.context.getName() + ") thread "));
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)bar.endsWith("bar"));
    }

    public void testGetThreadNameCustomPattern() throws Exception {
        this.context.getExecutorServiceStrategy().setThreadNamePattern("##counter# - #name#");
        String foo = this.context.getExecutorServiceStrategy().getThreadName("foo");
        String bar = this.context.getExecutorServiceStrategy().getThreadName("bar");
        DefaultExecutorServiceStrategyTest.assertNotSame((Object)foo, (Object)bar);
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)foo.startsWith("#"));
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)foo.endsWith(" - foo"));
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)bar.startsWith("#"));
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)bar.endsWith(" - bar"));
    }

    public void testGetThreadNameCustomPatternCamelId() throws Exception {
        this.context.getExecutorServiceStrategy().setThreadNamePattern("##camelId# - ##counter# - #name#");
        String foo = this.context.getExecutorServiceStrategy().getThreadName("foo");
        String bar = this.context.getExecutorServiceStrategy().getThreadName("bar");
        DefaultExecutorServiceStrategyTest.assertNotSame((Object)foo, (Object)bar);
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)foo.startsWith("#" + this.context.getName() + " - #"));
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)foo.endsWith(" - foo"));
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)bar.startsWith("#" + this.context.getName() + " - #"));
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)bar.endsWith(" - bar"));
    }

    public void testGetThreadNameCustomPatternWithDollar() throws Exception {
        this.context.getExecutorServiceStrategy().setThreadNamePattern("Hello - #name#");
        String foo = this.context.getExecutorServiceStrategy().getThreadName("foo$bar");
        DefaultExecutorServiceStrategyTest.assertEquals((String)"Hello - foo$bar", (String)foo);
    }

    public void testGetThreadNameCustomPatternLongName() throws Exception {
        this.context.getExecutorServiceStrategy().setThreadNamePattern("##counter# - #longName#");
        String foo = this.context.getExecutorServiceStrategy().getThreadName("foo?beer=Carlsberg");
        String bar = this.context.getExecutorServiceStrategy().getThreadName("bar");
        DefaultExecutorServiceStrategyTest.assertNotSame((Object)foo, (Object)bar);
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)foo.startsWith("#"));
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)foo.endsWith(" - foo?beer=Carlsberg"));
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)bar.startsWith("#"));
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)bar.endsWith(" - bar"));
    }

    public void testGetThreadNameCustomPatternWithParameters() throws Exception {
        this.context.getExecutorServiceStrategy().setThreadNamePattern("##counter# - #name#");
        String foo = this.context.getExecutorServiceStrategy().getThreadName("foo?beer=Carlsberg");
        String bar = this.context.getExecutorServiceStrategy().getThreadName("bar");
        DefaultExecutorServiceStrategyTest.assertNotSame((Object)foo, (Object)bar);
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)foo.startsWith("#"));
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)foo.endsWith(" - foo"));
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)bar.startsWith("#"));
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)bar.endsWith(" - bar"));
    }

    public void testGetThreadNameCustomPatternNoCounter() throws Exception {
        this.context.getExecutorServiceStrategy().setThreadNamePattern("Cool #name#");
        String foo = this.context.getExecutorServiceStrategy().getThreadName("foo");
        String bar = this.context.getExecutorServiceStrategy().getThreadName("bar");
        DefaultExecutorServiceStrategyTest.assertNotSame((Object)foo, (Object)bar);
        DefaultExecutorServiceStrategyTest.assertEquals((String)"Cool foo", (String)foo);
        DefaultExecutorServiceStrategyTest.assertEquals((String)"Cool bar", (String)bar);
    }

    public void testGetThreadNameCustomPatternInvalid() throws Exception {
        this.context.getExecutorServiceStrategy().setThreadNamePattern("Cool #xxx#");
        try {
            this.context.getExecutorServiceStrategy().getThreadName("foo");
            DefaultExecutorServiceStrategyTest.fail((String)"Should thrown an exception");
        }
        catch (IllegalArgumentException e) {
            DefaultExecutorServiceStrategyTest.assertEquals((String)"Pattern is invalid: Cool #xxx#", (String)e.getMessage());
        }
        this.context.getExecutorServiceStrategy().setThreadNamePattern("Camel Thread ##counter# - #name#");
    }

    public void testDefaultThreadPool() throws Exception {
        ExecutorService myPool = this.context.getExecutorServiceStrategy().newDefaultThreadPool((Object)this, "myPool");
        DefaultExecutorServiceStrategyTest.assertEquals((boolean)false, (boolean)myPool.isShutdown());
        ThreadPoolExecutor executor = (ThreadPoolExecutor)myPool;
        DefaultExecutorServiceStrategyTest.assertEquals((int)10, (int)executor.getCorePoolSize());
        DefaultExecutorServiceStrategyTest.assertEquals((int)20, (int)executor.getMaximumPoolSize());
        DefaultExecutorServiceStrategyTest.assertEquals((long)60L, (long)executor.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceStrategyTest.assertEquals((int)1000, (int)executor.getQueue().remainingCapacity());
        this.context.stop();
        DefaultExecutorServiceStrategyTest.assertEquals((boolean)true, (boolean)myPool.isShutdown());
    }

    public void testDefaultUnboundedQueueThreadPool() throws Exception {
        ThreadPoolProfileSupport custom = new ThreadPoolProfileSupport("custom");
        custom.setPoolSize(Integer.valueOf(10));
        custom.setMaxPoolSize(Integer.valueOf(30));
        custom.setKeepAliveTime(Long.valueOf(50L));
        custom.setMaxQueueSize(Integer.valueOf(Integer.MAX_VALUE));
        this.context.getExecutorServiceStrategy().setDefaultThreadPoolProfile((ThreadPoolProfile)custom);
        DefaultExecutorServiceStrategyTest.assertEquals((boolean)true, (boolean)custom.isDefaultProfile());
        ExecutorService myPool = this.context.getExecutorServiceStrategy().newDefaultThreadPool((Object)this, "myPool");
        DefaultExecutorServiceStrategyTest.assertEquals((boolean)false, (boolean)myPool.isShutdown());
        ThreadPoolExecutor executor = (ThreadPoolExecutor)myPool;
        DefaultExecutorServiceStrategyTest.assertEquals((int)10, (int)executor.getCorePoolSize());
        DefaultExecutorServiceStrategyTest.assertEquals((int)30, (int)executor.getMaximumPoolSize());
        DefaultExecutorServiceStrategyTest.assertEquals((long)50L, (long)executor.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceStrategyTest.assertEquals((int)Integer.MAX_VALUE, (int)executor.getQueue().remainingCapacity());
        this.context.stop();
        DefaultExecutorServiceStrategyTest.assertEquals((boolean)true, (boolean)myPool.isShutdown());
    }

    public void testCustomDefaultThreadPool() throws Exception {
        ThreadPoolProfileSupport custom = new ThreadPoolProfileSupport("custom");
        custom.setKeepAliveTime(Long.valueOf(20L));
        custom.setMaxPoolSize(Integer.valueOf(40));
        custom.setPoolSize(Integer.valueOf(5));
        custom.setMaxQueueSize(Integer.valueOf(2000));
        this.context.getExecutorServiceStrategy().setDefaultThreadPoolProfile((ThreadPoolProfile)custom);
        DefaultExecutorServiceStrategyTest.assertEquals((boolean)true, (boolean)custom.isDefaultProfile());
        ExecutorService myPool = this.context.getExecutorServiceStrategy().newDefaultThreadPool((Object)this, "myPool");
        DefaultExecutorServiceStrategyTest.assertEquals((boolean)false, (boolean)myPool.isShutdown());
        ThreadPoolExecutor executor = (ThreadPoolExecutor)myPool;
        DefaultExecutorServiceStrategyTest.assertEquals((int)5, (int)executor.getCorePoolSize());
        DefaultExecutorServiceStrategyTest.assertEquals((int)40, (int)executor.getMaximumPoolSize());
        DefaultExecutorServiceStrategyTest.assertEquals((long)20L, (long)executor.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceStrategyTest.assertEquals((int)2000, (int)executor.getQueue().remainingCapacity());
        this.context.stop();
        DefaultExecutorServiceStrategyTest.assertEquals((boolean)true, (boolean)myPool.isShutdown());
    }

    public void testGetThreadPoolProfile() throws Exception {
        DefaultExecutorServiceStrategyTest.assertNull((Object)this.context.getExecutorServiceStrategy().getThreadPoolProfile("foo"));
        ThreadPoolProfileSupport foo = new ThreadPoolProfileSupport("foo");
        foo.setKeepAliveTime(Long.valueOf(20L));
        foo.setMaxPoolSize(Integer.valueOf(40));
        foo.setPoolSize(Integer.valueOf(5));
        foo.setMaxQueueSize(Integer.valueOf(2000));
        this.context.getExecutorServiceStrategy().registerThreadPoolProfile((ThreadPoolProfile)foo);
        DefaultExecutorServiceStrategyTest.assertSame((Object)foo, (Object)this.context.getExecutorServiceStrategy().getThreadPoolProfile("foo"));
    }

    public void testTwoGetThreadPoolProfile() throws Exception {
        DefaultExecutorServiceStrategyTest.assertNull((Object)this.context.getExecutorServiceStrategy().getThreadPoolProfile("foo"));
        ThreadPoolProfileSupport foo = new ThreadPoolProfileSupport("foo");
        foo.setKeepAliveTime(Long.valueOf(20L));
        foo.setMaxPoolSize(Integer.valueOf(40));
        foo.setPoolSize(Integer.valueOf(5));
        foo.setMaxQueueSize(Integer.valueOf(2000));
        this.context.getExecutorServiceStrategy().registerThreadPoolProfile((ThreadPoolProfile)foo);
        ThreadPoolProfileSupport bar = new ThreadPoolProfileSupport("bar");
        bar.setKeepAliveTime(Long.valueOf(40L));
        bar.setMaxPoolSize(Integer.valueOf(5));
        bar.setPoolSize(Integer.valueOf(1));
        bar.setMaxQueueSize(Integer.valueOf(100));
        this.context.getExecutorServiceStrategy().registerThreadPoolProfile((ThreadPoolProfile)bar);
        DefaultExecutorServiceStrategyTest.assertSame((Object)foo, (Object)this.context.getExecutorServiceStrategy().getThreadPoolProfile("foo"));
        DefaultExecutorServiceStrategyTest.assertSame((Object)bar, (Object)this.context.getExecutorServiceStrategy().getThreadPoolProfile("bar"));
        DefaultExecutorServiceStrategyTest.assertNotSame((Object)foo, (Object)bar);
        DefaultExecutorServiceStrategyTest.assertFalse((boolean)this.context.getExecutorServiceStrategy().getThreadPoolProfile("foo").isDefaultProfile());
        DefaultExecutorServiceStrategyTest.assertFalse((boolean)this.context.getExecutorServiceStrategy().getThreadPoolProfile("bar").isDefaultProfile());
    }

    public void testGetThreadPoolProfileInheritDefaultValues() throws Exception {
        DefaultExecutorServiceStrategyTest.assertNull((Object)this.context.getExecutorServiceStrategy().getThreadPoolProfile("foo"));
        ThreadPoolProfileSupport foo = new ThreadPoolProfileSupport("foo");
        foo.setMaxPoolSize(Integer.valueOf(40));
        this.context.getExecutorServiceStrategy().registerThreadPoolProfile((ThreadPoolProfile)foo);
        DefaultExecutorServiceStrategyTest.assertSame((Object)foo, (Object)this.context.getExecutorServiceStrategy().getThreadPoolProfile("foo"));
        ExecutorService executor = this.context.getExecutorServiceStrategy().newThreadPool((Object)this, "MyPool", "foo");
        ThreadPoolExecutor tp = DefaultExecutorServiceStrategyTest.assertIsInstanceOf(ThreadPoolExecutor.class, executor);
        DefaultExecutorServiceStrategyTest.assertEquals((int)40, (int)tp.getMaximumPoolSize());
        DefaultExecutorServiceStrategyTest.assertEquals((int)10, (int)tp.getCorePoolSize());
        DefaultExecutorServiceStrategyTest.assertEquals((long)60L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceStrategyTest.assertEquals((String)"CallerRuns", (String)tp.getRejectedExecutionHandler().toString());
    }

    public void testGetThreadPoolProfileInheritCustomDefaultValues() throws Exception {
        ThreadPoolProfileSupport newDefault = new ThreadPoolProfileSupport("newDefault");
        newDefault.setKeepAliveTime(Long.valueOf(30L));
        newDefault.setMaxPoolSize(Integer.valueOf(50));
        newDefault.setPoolSize(Integer.valueOf(5));
        newDefault.setMaxQueueSize(Integer.valueOf(2000));
        newDefault.setRejectedPolicy(ThreadPoolRejectedPolicy.Abort);
        this.context.getExecutorServiceStrategy().setDefaultThreadPoolProfile((ThreadPoolProfile)newDefault);
        DefaultExecutorServiceStrategyTest.assertNull((Object)this.context.getExecutorServiceStrategy().getThreadPoolProfile("foo"));
        ThreadPoolProfileSupport foo = new ThreadPoolProfileSupport("foo");
        foo.setMaxPoolSize(Integer.valueOf(25));
        foo.setPoolSize(Integer.valueOf(1));
        this.context.getExecutorServiceStrategy().registerThreadPoolProfile((ThreadPoolProfile)foo);
        DefaultExecutorServiceStrategyTest.assertSame((Object)foo, (Object)this.context.getExecutorServiceStrategy().getThreadPoolProfile("foo"));
        ExecutorService executor = this.context.getExecutorServiceStrategy().newThreadPool((Object)this, "MyPool", "foo");
        ThreadPoolExecutor tp = DefaultExecutorServiceStrategyTest.assertIsInstanceOf(ThreadPoolExecutor.class, executor);
        DefaultExecutorServiceStrategyTest.assertEquals((int)25, (int)tp.getMaximumPoolSize());
        DefaultExecutorServiceStrategyTest.assertEquals((int)1, (int)tp.getCorePoolSize());
        DefaultExecutorServiceStrategyTest.assertEquals((long)30L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceStrategyTest.assertEquals((String)"Abort", (String)tp.getRejectedExecutionHandler().toString());
    }

    public void testGetThreadPoolProfileInheritCustomDefaultValues2() throws Exception {
        ThreadPoolProfileSupport newDefault = new ThreadPoolProfileSupport("newDefault");
        newDefault.setMaxPoolSize(Integer.valueOf(50));
        this.context.getExecutorServiceStrategy().setDefaultThreadPoolProfile((ThreadPoolProfile)newDefault);
        DefaultExecutorServiceStrategyTest.assertNull((Object)this.context.getExecutorServiceStrategy().getThreadPoolProfile("foo"));
        ThreadPoolProfileSupport foo = new ThreadPoolProfileSupport("foo");
        foo.setPoolSize(Integer.valueOf(1));
        this.context.getExecutorServiceStrategy().registerThreadPoolProfile((ThreadPoolProfile)foo);
        DefaultExecutorServiceStrategyTest.assertSame((Object)foo, (Object)this.context.getExecutorServiceStrategy().getThreadPoolProfile("foo"));
        ExecutorService executor = this.context.getExecutorServiceStrategy().newThreadPool((Object)this, "MyPool", "foo");
        ThreadPoolExecutor tp = DefaultExecutorServiceStrategyTest.assertIsInstanceOf(ThreadPoolExecutor.class, executor);
        DefaultExecutorServiceStrategyTest.assertEquals((int)1, (int)tp.getCorePoolSize());
        DefaultExecutorServiceStrategyTest.assertEquals((int)50, (int)tp.getMaximumPoolSize());
        DefaultExecutorServiceStrategyTest.assertEquals((long)60L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceStrategyTest.assertEquals((String)"CallerRuns", (String)tp.getRejectedExecutionHandler().toString());
    }

    public void testNewThreadPoolProfile() throws Exception {
        DefaultExecutorServiceStrategyTest.assertNull((Object)this.context.getExecutorServiceStrategy().getThreadPoolProfile("foo"));
        ThreadPoolProfileSupport foo = new ThreadPoolProfileSupport("foo");
        foo.setKeepAliveTime(Long.valueOf(20L));
        foo.setMaxPoolSize(Integer.valueOf(40));
        foo.setPoolSize(Integer.valueOf(5));
        foo.setMaxQueueSize(Integer.valueOf(2000));
        this.context.getExecutorServiceStrategy().registerThreadPoolProfile((ThreadPoolProfile)foo);
        ExecutorService pool = this.context.getExecutorServiceStrategy().newThreadPool((Object)this, "Cool", "foo");
        DefaultExecutorServiceStrategyTest.assertNotNull((Object)pool);
        ThreadPoolExecutor tp = DefaultExecutorServiceStrategyTest.assertIsInstanceOf(ThreadPoolExecutor.class, pool);
        DefaultExecutorServiceStrategyTest.assertEquals((long)20L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceStrategyTest.assertEquals((int)40, (int)tp.getMaximumPoolSize());
        DefaultExecutorServiceStrategyTest.assertEquals((int)5, (int)tp.getCorePoolSize());
        DefaultExecutorServiceStrategyTest.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)tp.isShutdown());
    }

    public void testLookupThreadPoolProfile() throws Exception {
        ExecutorService pool = this.context.getExecutorServiceStrategy().lookup((Object)this, "Cool", "fooProfile");
        DefaultExecutorServiceStrategyTest.assertNull((Object)pool);
        DefaultExecutorServiceStrategyTest.assertNull((Object)this.context.getExecutorServiceStrategy().getThreadPoolProfile("fooProfile"));
        ThreadPoolProfileSupport foo = new ThreadPoolProfileSupport("fooProfile");
        foo.setKeepAliveTime(Long.valueOf(20L));
        foo.setMaxPoolSize(Integer.valueOf(40));
        foo.setPoolSize(Integer.valueOf(5));
        foo.setMaxQueueSize(Integer.valueOf(2000));
        this.context.getExecutorServiceStrategy().registerThreadPoolProfile((ThreadPoolProfile)foo);
        pool = this.context.getExecutorServiceStrategy().lookup((Object)this, "Cool", "fooProfile");
        DefaultExecutorServiceStrategyTest.assertNotNull((Object)pool);
        ThreadPoolExecutor tp = DefaultExecutorServiceStrategyTest.assertIsInstanceOf(ThreadPoolExecutor.class, pool);
        DefaultExecutorServiceStrategyTest.assertEquals((long)20L, (long)tp.getKeepAliveTime(TimeUnit.SECONDS));
        DefaultExecutorServiceStrategyTest.assertEquals((int)40, (int)tp.getMaximumPoolSize());
        DefaultExecutorServiceStrategyTest.assertEquals((int)5, (int)tp.getCorePoolSize());
        DefaultExecutorServiceStrategyTest.assertFalse((boolean)tp.isShutdown());
        this.context.stop();
        DefaultExecutorServiceStrategyTest.assertTrue((boolean)tp.isShutdown());
    }
}

