/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.JndiRegistry;

public class DefaultComponentTest
extends ContextTestSupport {
    public void testGetAndRemoveParameterEmptyMap() {
        HashMap parameters = new HashMap();
        MyComponent my = new MyComponent((CamelContext)this.context);
        Integer value = (Integer)my.getAndRemoveParameter(parameters, "size", Integer.class);
        DefaultComponentTest.assertNull((Object)value);
    }

    public void testGetAndRemoveParameterEmptyMapDefault() {
        HashMap parameters = new HashMap();
        MyComponent my = new MyComponent((CamelContext)this.context);
        Integer value = (Integer)my.getAndRemoveParameter(parameters, "size", Integer.class, 5);
        DefaultComponentTest.assertEquals((int)value, (int)5);
    }

    public void testGetAndRemoveParameterEmptyMapDefaultIsNull() {
        HashMap parameters = new HashMap();
        MyComponent my = new MyComponent((CamelContext)this.context);
        Integer value = (Integer)my.getAndRemoveParameter(parameters, "size", Integer.class, null);
        DefaultComponentTest.assertNull((Object)value);
    }

    public void testGetAndRemoveParameterToInteger() {
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("size", 200);
        MyComponent my = new MyComponent((CamelContext)this.context);
        Integer value = (Integer)my.getAndRemoveParameter(parameters, "size", Integer.class);
        DefaultComponentTest.assertEquals((int)value, (int)200);
    }

    public void testGetAndRemoveParameterToIntegerDefault() {
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("size", 200);
        MyComponent my = new MyComponent((CamelContext)this.context);
        Integer value = (Integer)my.getAndRemoveParameter(parameters, "level", Integer.class, 4);
        DefaultComponentTest.assertEquals((int)value, (int)4);
    }

    public void testResolveAndRemoveReferenceParameter() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("date", "#beginning");
        MyComponent my = new MyComponent((CamelContext)this.context);
        Date value = (Date)my.resolveAndRemoveReferenceParameter(parameters, "date", Date.class);
        DefaultComponentTest.assertEquals((Object)new Date(0L), (Object)value);
        parameters.put("date", "beginning");
        value = (Date)my.resolveAndRemoveReferenceParameter(parameters, "date", Date.class);
        DefaultComponentTest.assertEquals((Object)new Date(0L), (Object)value);
    }

    public void testResolveAndRemoveReferenceParameterNotInRegistry() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("date", "#somewhen");
        MyComponent my = new MyComponent((CamelContext)this.context);
        try {
            my.resolveAndRemoveReferenceParameter(parameters, "date", Date.class);
            DefaultComponentTest.fail((String)"returned without finding object in registry");
        }
        catch (NoSuchBeanException e) {
            DefaultComponentTest.assertEquals((String)"No bean could be found in the registry for: somewhen of type: java.util.Date", (String)e.getMessage());
        }
    }

    public void testResolveAndRemoveReferenceParameterNotInMapDefault() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("date", "#beginning");
        MyComponent my = new MyComponent((CamelContext)this.context);
        Date value = (Date)my.resolveAndRemoveReferenceParameter(parameters, "wrong", Date.class, new Date(1L));
        DefaultComponentTest.assertEquals((Object)new Date(1L), (Object)value);
    }

    public void testResolveAndRemoveReferenceParameterNotInMapNull() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("date", "#beginning");
        MyComponent my = new MyComponent((CamelContext)this.context);
        Date value = (Date)my.resolveAndRemoveReferenceParameter(parameters, "wrong", Date.class);
        DefaultComponentTest.assertNull((Object)value);
    }

    public void testResolveAndRemoveReferenceListParameterElement() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dates", "#bean1");
        MyComponent my = new MyComponent((CamelContext)this.context);
        List values = my.resolveAndRemoveReferenceListParameter(parameters, "dates", Date.class);
        DefaultComponentTest.assertEquals((int)1, (int)values.size());
        DefaultComponentTest.assertEquals((Object)new Date(10L), values.get(0));
    }

    public void testResolveAndRemoveReferenceListParameterListComma() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dates", "#bean1,#bean2");
        MyComponent my = new MyComponent((CamelContext)this.context);
        List values = my.resolveAndRemoveReferenceListParameter(parameters, "dates", Date.class);
        DefaultComponentTest.assertEquals((int)2, (int)values.size());
        DefaultComponentTest.assertEquals((Object)new Date(10L), values.get(0));
        DefaultComponentTest.assertEquals((Object)new Date(11L), values.get(1));
        parameters.put("dates", "bean1,bean2");
        values = my.resolveAndRemoveReferenceListParameter(parameters, "dates", Date.class);
        DefaultComponentTest.assertEquals((int)2, (int)values.size());
        DefaultComponentTest.assertEquals((Object)new Date(10L), values.get(0));
        DefaultComponentTest.assertEquals((Object)new Date(11L), values.get(1));
    }

    public void testResolveAndRemoveReferenceListParameterListCommaTrim() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dates", " #bean1 , #bean2 ");
        MyComponent my = new MyComponent((CamelContext)this.context);
        List values = my.resolveAndRemoveReferenceListParameter(parameters, "dates", Date.class);
        DefaultComponentTest.assertEquals((int)2, (int)values.size());
        DefaultComponentTest.assertEquals((Object)new Date(10L), values.get(0));
        DefaultComponentTest.assertEquals((Object)new Date(11L), values.get(1));
        parameters.put("dates", " bean1 , bean2 ");
        values = my.resolveAndRemoveReferenceListParameter(parameters, "dates", Date.class);
        DefaultComponentTest.assertEquals((int)2, (int)values.size());
        DefaultComponentTest.assertEquals((Object)new Date(10L), values.get(0));
        DefaultComponentTest.assertEquals((Object)new Date(11L), values.get(1));
    }

    public void testResolveAndRemoveReferenceListParameterListBean() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dates", "#listBean");
        MyComponent my = new MyComponent((CamelContext)this.context);
        List values = my.resolveAndRemoveReferenceListParameter(parameters, "dates", Date.class);
        DefaultComponentTest.assertEquals((int)2, (int)values.size());
        DefaultComponentTest.assertEquals((Object)new Date(10L), values.get(0));
        DefaultComponentTest.assertEquals((Object)new Date(11L), values.get(1));
        parameters.put("dates", "#listBean");
        values = my.resolveAndRemoveReferenceListParameter(parameters, "dates", Date.class);
        DefaultComponentTest.assertEquals((int)2, (int)values.size());
        DefaultComponentTest.assertEquals((Object)new Date(10L), values.get(0));
        DefaultComponentTest.assertEquals((Object)new Date(11L), values.get(1));
    }

    public void testResolveAndRemoveReferenceListParameterInvalidBean() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dates", "#bean1,#bean3");
        MyComponent my = new MyComponent((CamelContext)this.context);
        try {
            my.resolveAndRemoveReferenceListParameter(parameters, "dates", Date.class);
            DefaultComponentTest.fail((String)"returned without finding object in registry");
        }
        catch (NoSuchBeanException e) {
            DefaultComponentTest.assertEquals((String)"No bean could be found in the registry for: bean3 of type: java.util.Date", (String)e.getMessage());
        }
    }

    public void testGetAndRemoveOrResolveReferenceParameter() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("size", 123);
        parameters.put("date", "#bean1");
        MyComponent my = new MyComponent((CamelContext)this.context);
        Integer value = (Integer)my.getAndRemoveOrResolveReferenceParameter(parameters, "size", Integer.class);
        DefaultComponentTest.assertNotNull((Object)value);
        DefaultComponentTest.assertEquals((int)123, (int)value);
        DefaultComponentTest.assertEquals((int)1, (int)parameters.size());
        Date bean1 = (Date)my.getAndRemoveOrResolveReferenceParameter(parameters, "date", Date.class);
        DefaultComponentTest.assertNotNull((Object)bean1);
        DefaultComponentTest.assertEquals((Object)new Date(10L), (Object)bean1);
        DefaultComponentTest.assertEquals((int)0, (int)parameters.size());
        Integer age = (Integer)my.getAndRemoveOrResolveReferenceParameter(parameters, "age", Integer.class, 7);
        DefaultComponentTest.assertNotNull((Object)age);
        DefaultComponentTest.assertEquals((int)7, (int)age);
    }

    public void testContextShouldBeSet() throws Exception {
        MyComponent my = new MyComponent(null);
        try {
            my.start();
            DefaultComponentTest.fail((String)"Should have thrown a IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            DefaultComponentTest.assertEquals((String)"camelContext must be specified", (String)e.getMessage());
        }
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        Date bean1 = new Date(10L);
        Date bean2 = new Date(11L);
        JndiRegistry jndiRegistry = super.createRegistry();
        jndiRegistry.bind("beginning", (Object)new Date(0L));
        jndiRegistry.bind("bean1", (Object)bean1);
        jndiRegistry.bind("bean2", (Object)bean2);
        jndiRegistry.bind("listBean", Arrays.asList(bean1, bean2));
        return jndiRegistry;
    }

    private static final class MyComponent
    extends DefaultComponent {
        private MyComponent(CamelContext context) {
            super(context);
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
            return null;
        }
    }
}

