/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.InputStream;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.camel.impl.DefaultClassResolver;

public class DefaultClassResolverTest
extends TestCase {
    public void testResolveClass() {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Class clazz = resolver.resolveClass("java.lang.Integer");
        DefaultClassResolverTest.assertNotNull((Object)clazz);
    }

    public void testResolveClassType() {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Class clazz = resolver.resolveClass("java.lang.Integer", Integer.class);
        DefaultClassResolverTest.assertNotNull((Object)clazz);
    }

    public void testResolveClassClassLoader() {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Class clazz = resolver.resolveClass("java.lang.Integer", DefaultClassResolverTest.class.getClassLoader());
        DefaultClassResolverTest.assertNotNull((Object)clazz);
    }

    public void testResolveClassClassLoaderType() {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Class clazz = resolver.resolveClass("java.lang.Integer", Integer.class, DefaultClassResolverTest.class.getClassLoader());
        DefaultClassResolverTest.assertNotNull((Object)clazz);
    }

    public void testResolveMandatoryClass() throws Exception {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Class clazz = resolver.resolveMandatoryClass("java.lang.Integer");
        DefaultClassResolverTest.assertNotNull((Object)clazz);
    }

    public void testResolveMandatoryClassType() throws Exception {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Class clazz = resolver.resolveMandatoryClass("java.lang.Integer", Integer.class);
        DefaultClassResolverTest.assertNotNull((Object)clazz);
    }

    public void testResolveMandatorySimpleClassType() throws Exception {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Class clazz = resolver.resolveMandatoryClass("Byte", Byte.class);
        DefaultClassResolverTest.assertNotNull((Object)clazz);
        clazz = resolver.resolveMandatoryClass("java.lang.Byte", Byte.class);
        DefaultClassResolverTest.assertNotNull((Object)clazz);
        Class clazz2 = resolver.resolveMandatoryClass("Long", Long.class);
        DefaultClassResolverTest.assertNotNull((Object)clazz2);
        clazz2 = resolver.resolveMandatoryClass("java.lang.Long", Long.class);
        DefaultClassResolverTest.assertNotNull((Object)clazz2);
        Class clazz3 = resolver.resolveMandatoryClass("String", String.class);
        DefaultClassResolverTest.assertNotNull((Object)clazz3);
        clazz3 = resolver.resolveMandatoryClass("java.lang.String", String.class);
        DefaultClassResolverTest.assertNotNull((Object)clazz3);
        Class clazz4 = resolver.resolveMandatoryClass("Byte[]", Byte[].class);
        DefaultClassResolverTest.assertNotNull((Object)clazz4);
        clazz4 = resolver.resolveMandatoryClass("java.lang.Byte[]", Byte[].class);
        DefaultClassResolverTest.assertNotNull((Object)clazz4);
        Class clazz5 = resolver.resolveMandatoryClass("Object[]", Object[].class);
        DefaultClassResolverTest.assertNotNull((Object)clazz5);
        clazz5 = resolver.resolveMandatoryClass("java.lang.Object[]", Object[].class);
        DefaultClassResolverTest.assertNotNull((Object)clazz5);
        Class clazz6 = resolver.resolveMandatoryClass("String[]", String[].class);
        DefaultClassResolverTest.assertNotNull((Object)clazz6);
        clazz6 = resolver.resolveMandatoryClass("java.lang.String[]", String[].class);
        DefaultClassResolverTest.assertNotNull((Object)clazz6);
    }

    public void testResolveMandatoryClassClassLoader() throws Exception {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Class clazz = resolver.resolveMandatoryClass("java.lang.Integer", DefaultClassResolverTest.class.getClassLoader());
        DefaultClassResolverTest.assertNotNull((Object)clazz);
    }

    public void testResolveMandatoryClassClassLoaderType() throws Exception {
        DefaultClassResolver resolver = new DefaultClassResolver();
        Class clazz = resolver.resolveMandatoryClass("java.lang.Integer", Integer.class, DefaultClassResolverTest.class.getClassLoader());
        DefaultClassResolverTest.assertNotNull((Object)clazz);
    }

    public void testResolveMandatoryClassNotFound() {
        DefaultClassResolver resolver = new DefaultClassResolver();
        try {
            resolver.resolveMandatoryClass("com.FooBar");
            DefaultClassResolverTest.fail((String)"Should thrown an exception");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void testLoadResourceAsUri() {
        DefaultClassResolver resolver = new DefaultClassResolver();
        URL url = resolver.loadResourceAsURL("log4j.properties");
        DefaultClassResolverTest.assertNotNull((Object)url);
    }

    public void testLoadResourceAsStream() {
        DefaultClassResolver resolver = new DefaultClassResolver();
        InputStream is = resolver.loadResourceAsStream("log4j.properties");
        DefaultClassResolverTest.assertNotNull((Object)is);
    }
}

