/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ComponentConfiguration;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.URIField;
import org.apache.camel.impl.ConfigurationHelper;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultEndpointConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationHelperTest {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationHelperTest.class);
    private static final String URIDUMP_SCHEME = "uri-dump";
    private static final String DUMMY_SCHEME = "dummy";
    private CamelContext context;

    @Before
    public void createContext() throws Exception {
        this.context = new DefaultCamelContext();
        ConfiguredComponent component = new ConfiguredComponent();
        this.context.addComponent(URIDUMP_SCHEME, (Component)component);
        this.context.addComponent(DUMMY_SCHEME, (Component)component);
        this.context.start();
    }

    @After
    public void destroyContext() throws Exception {
        this.context.stop();
        this.context = null;
    }

    @Test
    public void testUrnNoQuery() throws Exception {
        EndpointConfiguration cfg = ConfigurationHelper.createConfiguration((String)"uri-dump:foo", (CamelContext)this.context);
        ConfigurationHelperTest.logConfigurationObject(cfg);
        Assert.assertEquals((Object)URIDUMP_SCHEME, (Object)cfg.getParameter("scheme"));
        Assert.assertEquals((Object)"foo", (Object)cfg.getParameter("schemeSpecificPart"));
        Assert.assertEquals((String)"URNs don't set the authority field", null, (Object)cfg.getParameter("authority"));
        Assert.assertEquals((String)"URNs don't set the userInfo field", null, (Object)cfg.getParameter("userInfo"));
        Assert.assertEquals((String)"URNs don't set the host field", null, (Object)cfg.getParameter("host"));
        Assert.assertEquals((String)"URNs don't set the port field", (Object)-1, (Object)cfg.getParameter("port"));
        Assert.assertEquals((String)"URNs don't set the path field", null, (Object)cfg.getParameter("path"));
        Assert.assertEquals((String)"URNs don't set the query field", null, (Object)cfg.getParameter("query"));
        Assert.assertEquals((String)"URNs don't set the fragment field", null, (Object)cfg.getParameter("fragment"));
    }

    @Test
    public void testUrnWithQuery() throws Exception {
        EndpointConfiguration cfg = ConfigurationHelper.createConfiguration((String)"uri-dump:hadrian@localhost:9001/context/path/?bar=true&baz=2#1234", (CamelContext)this.context);
        ConfigurationHelperTest.logConfigurationObject(cfg);
        Assert.assertEquals((Object)URIDUMP_SCHEME, (Object)cfg.getParameter("scheme"));
        Assert.assertEquals((Object)"hadrian@localhost:9001/context/path/?bar=true&baz=2#1234", (Object)cfg.getParameter("schemeSpecificPart"));
        Assert.assertEquals((String)"URNs don't set the authority field", null, (Object)cfg.getParameter("authority"));
        Assert.assertEquals((String)"URNs don't set the userInfo field", null, (Object)cfg.getParameter("userInfo"));
        Assert.assertEquals((String)"URNs don't set the host field", null, (Object)cfg.getParameter("host"));
        Assert.assertEquals((String)"URNs don't set the port field", (Object)-1, (Object)cfg.getParameter("port"));
        Assert.assertEquals((String)"URNs don't set the path field", null, (Object)cfg.getParameter("path"));
        Assert.assertEquals((String)"URNs don't set the query field", null, (Object)cfg.getParameter("query"));
        Assert.assertEquals((String)"URNs don't set the fragment field", null, (Object)cfg.getParameter("fragment"));
    }

    @Test
    public void testUrlSimple() throws Exception {
        EndpointConfiguration cfg = ConfigurationHelper.createConfiguration((String)"uri-dump://foo", (CamelContext)this.context);
        ConfigurationHelperTest.logConfigurationObject(cfg);
        Assert.assertEquals((Object)URIDUMP_SCHEME, (Object)cfg.getParameter("scheme"));
        Assert.assertEquals((Object)"//foo", (Object)cfg.getParameter("schemeSpecificPart"));
        Assert.assertEquals((Object)"foo", (Object)cfg.getParameter("authority"));
        Assert.assertEquals(null, (Object)cfg.getParameter("userInfo"));
        Assert.assertEquals((Object)"foo", (Object)cfg.getParameter("host"));
        Assert.assertEquals((Object)-1, (Object)cfg.getParameter("port"));
        Assert.assertEquals((Object)"", (Object)cfg.getParameter("path"));
        Assert.assertEquals(null, (Object)cfg.getParameter("query"));
        Assert.assertEquals(null, (Object)cfg.getParameter("fragment"));
    }

    @Test
    public void testUrlWithPath() throws Exception {
        EndpointConfiguration cfg = ConfigurationHelper.createConfiguration((String)"uri-dump://foo/bar#defrag", (CamelContext)this.context);
        ConfigurationHelperTest.logConfigurationObject(cfg);
        Assert.assertEquals((Object)URIDUMP_SCHEME, (Object)cfg.getParameter("scheme"));
        Assert.assertEquals((Object)"//foo/bar#defrag", (Object)cfg.getParameter("schemeSpecificPart"));
        Assert.assertEquals((Object)"foo", (Object)cfg.getParameter("authority"));
        Assert.assertEquals(null, (Object)cfg.getParameter("userInfo"));
        Assert.assertEquals((Object)"foo", (Object)cfg.getParameter("host"));
        Assert.assertEquals((Object)-1, (Object)cfg.getParameter("port"));
        Assert.assertEquals((Object)"/bar#defrag", (Object)cfg.getParameter("path"));
        Assert.assertEquals(null, (Object)cfg.getParameter("query"));
        Assert.assertEquals(null, (Object)cfg.getParameter("fragment"));
    }

    @Test
    public void testUrlWithQuery() throws Exception {
        EndpointConfiguration cfg = ConfigurationHelper.createConfiguration((String)"uri-dump://hadrian@localhost:9001/context/path/?bar=true&baz=2#none", (CamelContext)this.context);
        ConfigurationHelperTest.logConfigurationObject(cfg);
        Assert.assertEquals((Object)URIDUMP_SCHEME, (Object)cfg.getParameter("scheme"));
        Assert.assertEquals((Object)"//hadrian@localhost:9001/context/path/?bar=true&baz=2#none", (Object)cfg.getParameter("schemeSpecificPart"));
        Assert.assertEquals((Object)"hadrian@localhost:9001", (Object)cfg.getParameter("authority"));
        Assert.assertEquals((Object)"hadrian", (Object)cfg.getParameter("userInfo"));
        Assert.assertEquals((Object)"localhost", (Object)cfg.getParameter("host"));
        Assert.assertEquals((Object)9001, (Object)cfg.getParameter("port"));
        Assert.assertEquals((Object)"/context/path/", (Object)cfg.getParameter("path"));
        Assert.assertEquals((Object)"bar=true&baz=2#none", (Object)cfg.getParameter("query"));
        Assert.assertEquals(null, (Object)cfg.getParameter("fragment"));
    }

    @Test
    public void testConfigurationFormat() throws Exception {
        EndpointConfiguration config = ConfigurationHelper.createConfiguration((String)"uri-dump:foo", (CamelContext)this.context);
        Assert.assertEquals(null, (Object)config.toUriString(EndpointConfiguration.UriFormat.Canonical));
        Assert.assertEquals(null, (Object)config.toUriString(EndpointConfiguration.UriFormat.Provider));
        Assert.assertEquals(null, (Object)config.toUriString(EndpointConfiguration.UriFormat.Consumer));
        Assert.assertEquals(null, (Object)config.toUriString(EndpointConfiguration.UriFormat.Complete));
    }

    @Test
    public void testDummyConfiguration() throws Exception {
        String configUri = "dummy://foobar?first=one&second=2";
        EndpointConfiguration config = ConfigurationHelper.createConfiguration((String)configUri, (CamelContext)this.context);
        Assert.assertNotNull((Object)config);
        Assert.assertTrue((boolean)(config instanceof DummyConfiguration));
        Assert.assertEquals((Object)"one", (Object)config.getParameter("first"));
        Assert.assertEquals((Object)2, (Object)config.getParameter("second"));
    }

    protected static void logConfigurationObject(EndpointConfiguration config) {
        if (config == null) {
            return;
        }
        LOG.info("{} [", (Object)config.getClass().getCanonicalName());
        LOG.info("  uri={}", (Object)config.getURI().toASCIIString());
        LOG.info("  fields:");
        Class<?> clazz = config.getClass();
        Field[] fields = clazz.getDeclaredFields();
        HashMap<String, Field> map = new HashMap<String, Field>();
        URIField anno = null;
        for (Field field : fields) {
            anno = field.getAnnotation(URIField.class);
            String key = anno == null ? field.getName() : ("query".equals(anno.parameter()) ? anno.parameter() : anno.component());
            map.put(key, field);
        }
        ConfigurationHelperTest.logConfigurationField(config, map, "scheme", true);
        ConfigurationHelperTest.logConfigurationField(config, map, "schemeSpecificPart", true);
        ConfigurationHelperTest.logConfigurationField(config, map, "authority", true);
        ConfigurationHelperTest.logConfigurationField(config, map, "userInfo", true);
        ConfigurationHelperTest.logConfigurationField(config, map, "host", true);
        ConfigurationHelperTest.logConfigurationField(config, map, "port", true);
        ConfigurationHelperTest.logConfigurationField(config, map, "path", true);
        ConfigurationHelperTest.logConfigurationField(config, map, "query", true);
        ConfigurationHelperTest.logConfigurationField(config, map, "fragment", true);
        for (Field f : map.values()) {
            ConfigurationHelperTest.logConfigurationField(config, f);
        }
        LOG.info("]");
    }

    protected static void logConfigurationField(EndpointConfiguration config, Map<String, Field> fields, String key, boolean remove) {
        ConfigurationHelperTest.logConfigurationField(config, fields.get(key));
        if (remove) {
            fields.remove(key);
        }
    }

    protected static void logConfigurationField(EndpointConfiguration config, Field field) {
        if (field == null) {
            return;
        }
        URIField anno = field.getAnnotation(URIField.class);
        if (anno != null) {
            LOG.info("  @URIField(component = \"{}\", parameter = \"{}\")", (Object)anno.component(), (Object)anno.parameter());
        }
        LOG.info("  {} {}={}", new Object[]{field.getType().getName(), field.getName(), config.getParameter(field.getName())});
    }

    public static class DummyConfiguration
    extends DefaultEndpointConfiguration {
        private String path;
        @URIField(component="query", parameter="first")
        private String first;
        @URIField(component="query", parameter="second")
        private int second;

        DummyConfiguration(CamelContext camelContext) {
            super(camelContext);
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getFirst() {
            return this.first;
        }

        public void setFirst(String first) {
            this.first = first;
        }

        public int getSecond() {
            return this.second;
        }

        public void setSecond(int second) {
            this.second = second;
        }

        public String toUriString(EndpointConfiguration.UriFormat format) {
            return null;
        }
    }

    public static class UriDumpConfiguration
    extends DefaultEndpointConfiguration {
        private String scheme;
        private String schemeSpecificPart;
        private String authority;
        private String userInfo;
        private String host;
        private int port;
        private String path;
        private String query;
        private String fragment;

        public UriDumpConfiguration(CamelContext camelContext) {
            super(camelContext);
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setSchemeSpecificPart(String schemeSpecificPart) {
            this.schemeSpecificPart = schemeSpecificPart;
        }

        public String getSchemeSpecificPart() {
            return this.schemeSpecificPart;
        }

        public void setAuthority(String authority) {
            this.authority = authority;
        }

        public String getAuthority() {
            return this.authority;
        }

        public void setUserInfo(String userInfo) {
            this.userInfo = userInfo;
        }

        public String getUserInfo() {
            return this.userInfo;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getHost() {
            return this.host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public int getPort() {
            return this.port;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public String getQuery() {
            return this.query;
        }

        public void setFragment(String fragment) {
            this.fragment = fragment;
        }

        public String getFragment() {
            return this.fragment;
        }

        public String toUriString(EndpointConfiguration.UriFormat format) {
            return null;
        }
    }

    private static class ConfiguredComponent
    implements Component {
        private CamelContext context;

        private ConfiguredComponent() {
        }

        public void setCamelContext(CamelContext camelContext) {
            this.context = camelContext;
        }

        public CamelContext getCamelContext() {
            return this.context;
        }

        public Endpoint createEndpoint(String uri) throws Exception {
            return null;
        }

        public ComponentConfiguration createComponentConfiguration() {
            return null;
        }

        public EndpointConfiguration createConfiguration(String uri) throws Exception {
            if (uri.equals(ConfigurationHelperTest.URIDUMP_SCHEME)) {
                return new UriDumpConfiguration(this.getCamelContext());
            }
            if (uri.equals(ConfigurationHelperTest.DUMMY_SCHEME)) {
                return new DummyConfiguration(this.getCamelContext());
            }
            return null;
        }

        public boolean useRawUri() {
            return false;
        }
    }
}

