/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.converter.stream.FileInputStreamCache;
import org.apache.camel.converter.stream.InputStreamCache;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultUnitOfWork;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.IOHelper;

public class CachedOutputStreamTest
extends ContextTestSupport {
    private static final String TEST_STRING = "This is a test string and it has enough aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa ";
    private Exchange exchange;

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.setStreamCaching(Boolean.valueOf(true));
        context.getStreamCachingStrategy().setSpoolDirectory("target/cachedir");
        context.getStreamCachingStrategy().setSpoolThreshold(16L);
        return context;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        CachedOutputStreamTest.deleteDirectory("target/cachedir");
        CachedOutputStreamTest.createDirectory("target/cachedir");
        this.exchange = new DefaultExchange((CamelContext)this.context);
        DefaultUnitOfWork uow = new DefaultUnitOfWork(this.exchange);
        this.exchange.setUnitOfWork((UnitOfWork)uow);
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    private static String toString(InputStream input) throws IOException {
        BufferedReader reader = IOHelper.buffered((Reader)new InputStreamReader(input));
        CollectionStringBuffer builder = new CollectionStringBuffer();
        String line;
        while ((line = reader.readLine()) != null) {
            builder.append((Object)line);
        }
        return builder.toString();
    }

    public void testCachedStreamAccessStreamWhenExchangeOnCompletion() throws Exception {
        this.context.start();
        CachedOutputStream cos = new CachedOutputStream(this.exchange, false);
        cos.write(TEST_STRING.getBytes("UTF-8"));
        File file = new File("target/cachedir");
        String[] files = file.list();
        CachedOutputStreamTest.assertEquals((String)"we should have a temp file", (int)1, (int)files.length);
        CachedOutputStreamTest.assertTrue((String)"The file name should start with cos", (boolean)files[0].startsWith("cos"));
        InputStream is = cos.getWrappedInputStream();
        this.exchange.getUnitOfWork().done(this.exchange);
        String temp = CachedOutputStreamTest.toString(is);
        CachedOutputStreamTest.assertEquals((String)"Get a wrong stream content", (String)temp, (String)TEST_STRING);
        IOHelper.close((Closeable)is);
        files = file.list();
        CachedOutputStreamTest.assertEquals((String)"we should have a temp file", (int)0, (int)files.length);
        IOHelper.close((Closeable)cos);
    }

    public void testCacheStreamToFileAndCloseStream() throws Exception {
        this.context.start();
        CachedOutputStream cos = new CachedOutputStream(this.exchange);
        cos.write(TEST_STRING.getBytes("UTF-8"));
        File file = new File("target/cachedir");
        String[] files = file.list();
        CachedOutputStreamTest.assertEquals((String)"we should have a temp file", (int)1, (int)files.length);
        CachedOutputStreamTest.assertTrue((String)"The file name should start with cos", (boolean)files[0].startsWith("cos"));
        StreamCache cache = cos.newStreamCache();
        CachedOutputStreamTest.assertTrue((String)"Should get the FileInputStreamCache", (boolean)(cache instanceof FileInputStreamCache));
        String temp = CachedOutputStreamTest.toString((InputStream)cache);
        ((InputStream)cache).close();
        files = file.list();
        CachedOutputStreamTest.assertEquals((String)"we should have a temp file", (int)1, (int)files.length);
        CachedOutputStreamTest.assertEquals((String)"Cached a wrong file", (String)temp, (String)TEST_STRING);
        this.exchange.getUnitOfWork().done(this.exchange);
        try {
            cache.reset();
            CachedOutputStreamTest.fail((String)"we expect the exception here");
        }
        catch (Exception exception) {
            // empty catch block
        }
        files = file.list();
        CachedOutputStreamTest.assertEquals((String)"we should have no temp file", (int)0, (int)files.length);
        IOHelper.close((Closeable)cos);
    }

    public void testCacheStreamToFileAndCloseStreamEncrypted() throws Exception {
        this.context.getStreamCachingStrategy().setSpoolChiper("RC4");
        this.context.start();
        CachedOutputStream cos = new CachedOutputStream(this.exchange);
        cos.write(TEST_STRING.getBytes("UTF-8"));
        cos.flush();
        File file = new File("target/cachedir");
        String[] files = file.list();
        CachedOutputStreamTest.assertEquals((String)"we should have a temp file", (int)1, (int)files.length);
        CachedOutputStreamTest.assertTrue((String)"The content is written", (new File(file, files[0]).length() > 10L ? 1 : 0) != 0);
        FileInputStream tmpin = new FileInputStream(new File(file, files[0]));
        String temp = CachedOutputStreamTest.toString(tmpin);
        CachedOutputStreamTest.assertTrue((String)"The content is not encrypted", (temp.length() > 0 && temp.indexOf("aaa") < 0 ? 1 : 0) != 0);
        tmpin.close();
        StreamCache cache = cos.newStreamCache();
        CachedOutputStreamTest.assertTrue((String)"Should get the FileInputStreamCache", (boolean)(cache instanceof FileInputStreamCache));
        temp = CachedOutputStreamTest.toString((InputStream)cache);
        ((InputStream)cache).close();
        CachedOutputStreamTest.assertEquals((String)"we should have a temp file", (int)1, (int)files.length);
        CachedOutputStreamTest.assertEquals((String)"Cached a wrong file", (String)temp, (String)TEST_STRING);
        this.exchange.getUnitOfWork().done(this.exchange);
        try {
            cache.reset();
            CachedOutputStreamTest.fail((String)"we expect the exception here");
        }
        catch (Exception exception) {
            // empty catch block
        }
        files = file.list();
        CachedOutputStreamTest.assertEquals((String)"we should have no temp file", (int)0, (int)files.length);
        IOHelper.close((Closeable)cos);
    }

    public void testCacheStreamToFileCloseStreamBeforeDone() throws Exception {
        this.context.start();
        CachedOutputStream cos = new CachedOutputStream(this.exchange);
        cos.write(TEST_STRING.getBytes("UTF-8"));
        File file = new File("target/cachedir");
        String[] files = file.list();
        CachedOutputStreamTest.assertEquals((String)"we should have a temp file", (int)1, (int)files.length);
        CachedOutputStreamTest.assertTrue((String)"The file name should start with cos", (boolean)files[0].startsWith("cos"));
        StreamCache cache = cos.newStreamCache();
        CachedOutputStreamTest.assertTrue((String)"Should get the FileInputStreamCache", (boolean)(cache instanceof FileInputStreamCache));
        String temp = CachedOutputStreamTest.toString((InputStream)cache);
        CachedOutputStreamTest.assertEquals((String)"Cached a wrong file", (String)temp, (String)TEST_STRING);
        cache.reset();
        temp = CachedOutputStreamTest.toString((InputStream)cache);
        CachedOutputStreamTest.assertEquals((String)"Cached a wrong file", (String)temp, (String)TEST_STRING);
        ((InputStream)cache).close();
        files = file.list();
        CachedOutputStreamTest.assertEquals((String)"we should have a temp file", (int)1, (int)files.length);
        this.exchange.getUnitOfWork().done(this.exchange);
        files = file.list();
        CachedOutputStreamTest.assertEquals((String)"we should have no temp file", (int)0, (int)files.length);
        IOHelper.close((Closeable)cos);
    }

    public void testCacheStreamToMemory() throws Exception {
        this.context.getStreamCachingStrategy().setSpoolThreshold(1024L);
        this.context.start();
        CachedOutputStream cos = new CachedOutputStream(this.exchange);
        cos.write(TEST_STRING.getBytes("UTF-8"));
        File file = new File("target/cachedir");
        String[] files = file.list();
        CachedOutputStreamTest.assertEquals((String)"we should have no temp file", (int)0, (int)files.length);
        StreamCache cache = cos.newStreamCache();
        CachedOutputStreamTest.assertTrue((String)"Should get the InputStreamCache", (boolean)(cache instanceof InputStreamCache));
        String temp = IOConverter.toString((InputStream)((InputStream)cache), null);
        CachedOutputStreamTest.assertEquals((String)"Cached a wrong file", (String)temp, (String)TEST_STRING);
        IOHelper.close((Closeable)cos);
    }

    public void testCacheStreamToMemoryAsDiskIsDisabled() throws Exception {
        this.context.getStreamCachingStrategy().setSpoolThreshold(-1L);
        this.context.start();
        CachedOutputStream cos = new CachedOutputStream(this.exchange);
        cos.write(TEST_STRING.getBytes("UTF-8"));
        File file = new File("target/cachedir");
        String[] files = file.list();
        CachedOutputStreamTest.assertEquals((String)"we should have no temp file", (int)0, (int)files.length);
        StreamCache cache = cos.newStreamCache();
        CachedOutputStreamTest.assertTrue((String)"Should get the InputStreamCache", (boolean)(cache instanceof InputStreamCache));
        String temp = IOConverter.toString((InputStream)((InputStream)cache), null);
        CachedOutputStreamTest.assertEquals((String)"Cached a wrong file", (String)temp, (String)TEST_STRING);
        this.exchange.getUnitOfWork().done(this.exchange);
        IOHelper.close((Closeable)cos);
    }

    public void testCachedOutputStreamCustomBufferSize() throws Exception {
        this.context.getStreamCachingStrategy().setBufferSize(8192);
        this.context.start();
        CachedOutputStream cos = new CachedOutputStream(this.exchange);
        cos.write(TEST_STRING.getBytes("UTF-8"));
        CachedOutputStreamTest.assertEquals((String)"we should have a custom buffer size", (int)cos.getStrategyBufferSize(), (int)8192);
        File file = new File("target/cachedir");
        String[] files = file.list();
        CachedOutputStreamTest.assertEquals((String)"we should have a temp file", (int)1, (int)files.length);
        CachedOutputStreamTest.assertTrue((String)"The file name should start with cos", (boolean)files[0].startsWith("cos"));
        StreamCache cache = cos.newStreamCache();
        CachedOutputStreamTest.assertTrue((String)"Should get the FileInputStreamCache", (boolean)(cache instanceof FileInputStreamCache));
        String temp = CachedOutputStreamTest.toString((InputStream)cache);
        CachedOutputStreamTest.assertEquals((String)"Cached a wrong file", (String)temp, (String)TEST_STRING);
        cache.reset();
        temp = CachedOutputStreamTest.toString((InputStream)cache);
        CachedOutputStreamTest.assertEquals((String)"Cached a wrong file", (String)temp, (String)TEST_STRING);
        ((InputStream)cache).close();
        files = file.list();
        CachedOutputStreamTest.assertEquals((String)"we should have a temp file", (int)1, (int)files.length);
        this.exchange.getUnitOfWork().done(this.exchange);
        files = file.list();
        CachedOutputStreamTest.assertEquals((String)"we should have no temp file", (int)0, (int)files.length);
        IOHelper.close((Closeable)cos);
    }
}

