/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.ResourceHelper;

public class XsltCustomizeURIResolverTest
extends ContextTestSupport {
    private static final String EXPECTED_XML_CONSTANT = "<data>FOO DATA</data>";

    public void testXsltCustomURIResolverDirectInRouteUri() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:resultURIResolverDirect");
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).body()).contains((Object)EXPECTED_XML_CONSTANT);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file:src/test/data/?fileName=staff.xml&noop=true").to("xslt:org/apache/camel/component/xslt/include_not_existing_resource.xsl?uriResolver=#customURIResolver")).to("mock:resultURIResolverDirect");
            }
        };
    }

    private URIResolver getCustomURIResolver() {
        return new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                if (href.equals("org/apache/camel/component/xslt/include_not_existing_resource.xsl")) {
                    try {
                        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)XsltCustomizeURIResolverTest.this.context.getClassResolver(), (String)href);
                        return new StreamSource(is);
                    }
                    catch (Exception e) {
                        throw new TransformerException(e);
                    }
                }
                StreamSource constantResult = new StreamSource(new ByteArrayInputStream(XsltCustomizeURIResolverTest.EXPECTED_XML_CONSTANT.getBytes()));
                return constantResult;
            }
        };
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry registry = super.createRegistry();
        URIResolver customURIResolver = this.getCustomURIResolver();
        registry.bind("customURIResolver", (Object)customURIResolver);
        return registry;
    }
}

