/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;

public class SedaTimeoutTest
extends ContextTestSupport {
    private int timeout = 100;

    public void testSedaNoTimeout() throws Exception {
        Future out = this.template.asyncRequestBody("seda:foo", (Object)"World", String.class);
        SedaTimeoutTest.assertEquals((String)"Bye World", (String)((String)out.get()));
    }

    public void testSedaTimeout() throws Exception {
        Future out = this.template.asyncRequestBody("seda:foo?timeout=" + this.timeout, (Object)"World", String.class);
        try {
            out.get();
            SedaTimeoutTest.fail((String)"Should have thrown an exception");
        }
        catch (ExecutionException e) {
            SedaTimeoutTest.assertIsInstanceOf(CamelExecutionException.class, e.getCause());
            SedaTimeoutTest.assertIsInstanceOf(ExchangeTimedOutException.class, e.getCause().getCause());
            SedaEndpoint se = (SedaEndpoint)this.context.getRoute("seda").getEndpoint();
            SedaTimeoutTest.assertNotNull((String)"Consumer endpoint cannot be null", (Object)se);
            SedaTimeoutTest.assertEquals((String)"Timeout Exchanges should be removed from queue", (int)0, (int)se.getCurrentQueueSize());
        }
    }

    public void testSedaTimeoutWithStoppedRoute() throws Exception {
        this.context.stopRoute("seda");
        this.timeout = 500;
        this.testSedaTimeout();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((RouteDefinition)this.from("seda:foo").routeId("seda").to("mock:before")).delay(250L).transform((Expression)this.body().prepend((Object)"Bye "))).to("mock:result");
            }
        };
    }
}

