/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;

public class SedaRouteTest
extends TestSupport {
    protected void setUp() throws Exception {
        System.setProperty("CamelSedaPollTimeout", "10");
        super.setUp();
    }

    protected void tearDown() throws Exception {
        System.clearProperty("CamelSedaPollTimeout");
        super.tearDown();
    }

    public void testSedaQueue() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultCamelContext context = new DefaultCamelContext();
        context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("seda:test.a").to("seda:test.b");
                this.from("seda:test.b").process(new Processor(){

                    public void process(Exchange e) {
                        log.debug("Received exchange: " + e.getIn());
                        latch.countDown();
                    }
                });
            }
        });
        context.start();
        Endpoint endpoint = context.getEndpoint("seda:test.a");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setHeader("cheese", (Object)123);
        Producer producer = endpoint.createProducer();
        producer.process(exchange);
        SedaRouteTest.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        context.stop();
    }

    public void testThatShowsEndpointResolutionIsNotConsistent() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultCamelContext context = new DefaultCamelContext();
        context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("seda:test.a").to("seda:test.b");
                this.from("seda:test.b").process(new Processor(){

                    public void process(Exchange e) {
                        log.debug("Received exchange: " + e.getIn());
                        latch.countDown();
                    }
                });
            }
        });
        context.start();
        Endpoint endpoint = context.getEndpoint("seda:test.a");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setHeader("cheese", (Object)123);
        Producer producer = endpoint.createProducer();
        producer.process(exchange);
        SedaRouteTest.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        context.stop();
    }
}

