/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.FromRestGetTest;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.VerbDefinition;

public class FromRestGetEndPathTest
extends FromRestGetTest {
    @Override
    public void testFromRestModel() throws Exception {
        FromRestGetEndPathTest.assertEquals((int)this.getExpectedNumberOfRoutes(), (int)this.context.getRoutes().size());
        FromRestGetEndPathTest.assertEquals((int)2, (int)this.context.getRestDefinitions().size());
        RestDefinition rest = (RestDefinition)this.context.getRestDefinitions().get(0);
        FromRestGetEndPathTest.assertNotNull((Object)rest);
        FromRestGetEndPathTest.assertEquals((String)"/say/hello", (String)rest.getPath());
        FromRestGetEndPathTest.assertEquals((int)1, (int)rest.getVerbs().size());
        ToDefinition to = FromRestGetEndPathTest.assertIsInstanceOf(ToDefinition.class, ((VerbDefinition)rest.getVerbs().get(0)).getTo());
        FromRestGetEndPathTest.assertEquals((String)"direct:hello", (String)to.getUri());
        rest = (RestDefinition)this.context.getRestDefinitions().get(1);
        FromRestGetEndPathTest.assertNotNull((Object)rest);
        FromRestGetEndPathTest.assertEquals((String)"/say/bye", (String)rest.getPath());
        FromRestGetEndPathTest.assertEquals((int)2, (int)rest.getVerbs().size());
        FromRestGetEndPathTest.assertEquals((String)"application/json", (String)((VerbDefinition)rest.getVerbs().get(0)).getConsumes());
        to = FromRestGetEndPathTest.assertIsInstanceOf(ToDefinition.class, ((VerbDefinition)rest.getVerbs().get(0)).getRoute().getOutputs().get(1));
        FromRestGetEndPathTest.assertEquals((String)"direct:bye", (String)to.getUri());
        this.getMockEndpoint("mock:update").expectedMessageCount(1);
        this.template.sendBody("seda:post-say-bye", (Object)"I was here");
        this.assertMockEndpointsSatisfied();
        String out = (String)this.template.requestBody("seda:get-say-hello", (Object)"Me", String.class);
        FromRestGetEndPathTest.assertEquals((String)"Hello World", (String)out);
        String out2 = (String)this.template.requestBody("seda:get-say-bye", (Object)"Me", String.class);
        FromRestGetEndPathTest.assertEquals((String)"Bye World", (String)out2);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().host("localhost");
                this.rest("/say/hello").get().to("direct:hello");
                ((RouteDefinition)this.rest("/say/bye").get().consumes("application/json").route().to("direct:bye")).endRest().post().to("mock:update");
                this.from("direct:hello").transform().constant((Object)"Hello World");
                this.from("direct:bye").transform().constant((Object)"Bye World");
            }
        };
    }
}

