/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.io.StringWriter;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.log.LogComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.PropertyPlaceholderDelegateRegistry;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class LogCustomLoggerTest
extends ContextTestSupport {
    private static StringWriter sw1;
    private static StringWriter sw2;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        sw1 = new StringWriter();
        sw2 = new StringWriter();
        Logger.getLogger(LogCustomLoggerTest.class).removeAllAppenders();
        Logger.getLogger(LogCustomLoggerTest.class).addAppender((Appender)new CapturingAppender(sw1));
        Logger.getLogger(LogCustomLoggerTest.class).setLevel(Level.TRACE);
        Logger.getLogger((String)"provided.logger1.name").removeAllAppenders();
        Logger.getLogger((String)"provided.logger1.name").addAppender((Appender)new CapturingAppender(sw1));
        Logger.getLogger((String)"provided.logger1.name").setLevel(Level.TRACE);
        Logger.getLogger((String)"provided.logger2.name").removeAllAppenders();
        Logger.getLogger((String)"provided.logger2.name").addAppender((Appender)new CapturingAppender(sw1));
        Logger.getLogger((String)"provided.logger2.name").setLevel(Level.TRACE);
        Logger.getLogger((String)"irrelevant.logger.name").removeAllAppenders();
        Logger.getLogger((String)"irrelevant.logger.name").addAppender((Appender)new CapturingAppender(sw1));
        Logger.getLogger((String)"irrelevant.logger.name").setLevel(Level.TRACE);
        Logger.getLogger(LogComponent.class).removeAllAppenders();
        Logger.getLogger(LogComponent.class).addAppender((Appender)new CapturingAppender(sw2));
        Logger.getLogger(LogComponent.class).setLevel(Level.TRACE);
    }

    @Test
    public void testFallbackLogger() throws Exception {
        String endpointUri = "log:" + LogCustomLoggerTest.class.getCanonicalName();
        this.template.requestBody(endpointUri, (Object)"hello");
        Assert.assertThat((Object)sw1.toString(), (Matcher)CoreMatchers.equalTo((Object)LogCustomLoggerTest.class.getCanonicalName()));
    }

    @Test
    public void testEndpointURIParametrizedLogger() throws Exception {
        this.getRegistry().put((Object)"logger1", (Object)LoggerFactory.getLogger((String)"provided.logger1.name"));
        this.getRegistry().put((Object)"logger2", (Object)LoggerFactory.getLogger((String)"provided.logger2.name"));
        this.template.requestBody("log:irrelevant.logger.name?logger=#logger2", (Object)"hello");
        Assert.assertThat((Object)sw1.toString(), (Matcher)CoreMatchers.equalTo((Object)"provided.logger2.name"));
    }

    @Test
    public void testEndpointURIParametrizedNotResolvableLogger() {
        this.getRegistry().put((Object)"logger1", (Object)LoggerFactory.getLogger((String)"provided.logger1.name"));
        try {
            this.template.requestBody("log:irrelevant.logger.name?logger=#logger2", (Object)"hello");
        }
        catch (ResolveEndpointFailedException resolveEndpointFailedException) {
            // empty catch block
        }
    }

    @Test
    public void testDefaultRegistryLogger() throws Exception {
        this.getRegistry().put((Object)"logger", (Object)LoggerFactory.getLogger((String)"provided.logger1.name"));
        this.template.requestBody("log:irrelevant.logger.name", (Object)"hello");
        Assert.assertThat((Object)sw1.toString(), (Matcher)CoreMatchers.equalTo((Object)"provided.logger1.name"));
    }

    @Test
    public void testTwoRegistryLoggers() throws Exception {
        this.getRegistry().put((Object)"logger1", (Object)LoggerFactory.getLogger((String)"provided.logger1.name"));
        this.getRegistry().put((Object)"logger2", (Object)LoggerFactory.getLogger((String)"provided.logger2.name"));
        this.template.requestBody("log:irrelevant.logger.name", (Object)"hello");
        Assert.assertThat((Object)sw1.toString(), (Matcher)CoreMatchers.equalTo((Object)"irrelevant.logger.name"));
        Assert.assertThat((Object)sw2.toString(), (Matcher)CoreMatchers.equalTo((Object)LogComponent.class.getName()));
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        return new DefaultCamelContext((Registry)new SimpleRegistry());
    }

    private SimpleRegistry getRegistry() {
        SimpleRegistry registry = null;
        if (this.context.getRegistry() instanceof PropertyPlaceholderDelegateRegistry) {
            registry = (SimpleRegistry)((PropertyPlaceholderDelegateRegistry)this.context.getRegistry()).getRegistry();
        } else {
            LogCustomLoggerTest.fail((String)"Could not determine Registry type");
        }
        return registry;
    }

    private static final class CapturingAppender
    extends AppenderSkeleton {
        private StringWriter sw;

        private CapturingAppender(StringWriter sw) {
            this.sw = sw;
        }

        protected void append(LoggingEvent event) {
            this.sw.append(event.getLoggerName());
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }
    }
}

