/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.processor.DefaultExchangeFormatter;

public class DefaultExchangeFormatterTest
extends ContextTestSupport {
    public void testSendMessageToLogDefault() throws Exception {
        this.template.sendBody("log:org.apache.camel.TEST", (Object)"Hello World");
    }

    public void testSendMessageToLogAllOff() throws Exception {
        this.template.sendBody("log:org.apache.camel.TEST?showBody=false&showBodyType=false&showExchangePattern=false", (Object)"Hello World");
    }

    public void testSendMessageToLogSingleOptions() throws Exception {
        this.template.sendBody("log:org.apache.camel.TEST?showExchangeId=true", (Object)"Hello World");
        this.template.sendBody("log:org.apache.camel.TEST?showExchangePattern=true", (Object)"Hello World");
        this.template.sendBody("log:org.apache.camel.TEST?showExchangePattern=false", (Object)"Hello World");
        this.template.sendBody("log:org.apache.camel.TEST?showProperties=true", (Object)"Hello World");
        this.template.sendBody("log:org.apache.camel.TEST?showHeaders=true", (Object)"Hello World");
        this.template.sendBody("log:org.apache.camel.TEST?showBodyType=true", (Object)"Hello World");
        this.template.sendBody("log:org.apache.camel.TEST?showBody=true", (Object)"Hello World");
        this.template.sendBody("log:org.apache.camel.TEST?showOut=true", (Object)"Hello World");
        this.template.sendBody("log:org.apache.camel.TEST?showOut=true&showHeaders=true", (Object)"Hello World");
        this.template.sendBody("log:org.apache.camel.TEST?showOut=true&showBodyType=true", (Object)"Hello World");
        this.template.sendBody("log:org.apache.camel.TEST?showOut=true&showBody=true", (Object)"Hello World");
        this.template.sendBody("log:org.apache.camel.TEST?showAll=true", (Object)"Hello World");
        this.template.sendBody("log:org.apache.camel.TEST?showFuture=true", (Object)new MyFuture(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return "foo";
            }
        }));
        this.template.sendBody("log:org.apache.camel.TEST?showFuture=false", (Object)new MyFuture(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return "bar";
            }
        }));
    }

    public void testSendMessageToLogMultiOptions() throws Exception {
        this.template.sendBody("log:org.apache.camel.TEST?showHeaders=true&showOut=true", (Object)"Hello World");
        this.template.sendBody("log:org.apache.camel.TEST?showProperties=true&showHeaders=true&showOut=true", (Object)"Hello World");
    }

    public void testSendMessageToLogShowFalse() throws Exception {
        this.template.sendBody("log:org.apache.camel.TEST?showBodyType=false", (Object)"Hello World");
    }

    public void testSendMessageToLogMultiLine() throws Exception {
        this.template.sendBody("log:org.apache.camel.TEST?multiline=true", (Object)"Hello World");
    }

    public void testSendByteArrayMessageToLogDefault() throws Exception {
        this.template.sendBody("log:org.apache.camel.TEST", (Object)"Hello World".getBytes());
    }

    public void testSendMessageToLogMaxChars() throws Exception {
        this.template.sendBody("log:org.apache.camel.TEST", (Object)"Hello World this is a very long string that is NOT going to be chopped by maxchars");
        this.template.sendBody("log:org.apache.camel.TEST?maxChars=50", (Object)"Hello World this is a very long string that is going to be chopped by maxchars");
        this.template.sendBody("log:org.apache.camel.TEST?maxChars=50&showAll=true&multiline=true", (Object)"Hello World this is a very long string that is going to be chopped by maxchars");
    }

    public void testSendExchangeWithOut() throws Exception {
        Endpoint endpoint = this.resolveMandatoryEndpoint("log:org.apache.camel.TEST?showAll=true&multiline=true");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setBody((Object)"Hello World");
        exchange.getOut().setBody((Object)22);
        Producer producer = endpoint.createProducer();
        producer.start();
        producer.process(exchange);
        producer.stop();
    }

    public void testSendExchangeWithException() throws Exception {
        Endpoint endpoint = this.resolveMandatoryEndpoint("log:org.apache.camel.TEST?showException=true");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setBody((Object)"Hello World");
        exchange.setException((Throwable)new IllegalArgumentException("Damn"));
        Producer producer = endpoint.createProducer();
        producer.start();
        producer.process(exchange);
        producer.stop();
    }

    public void testSendCaughtExchangeWithException() throws Exception {
        Endpoint endpoint = this.resolveMandatoryEndpoint("log:org.apache.camel.TEST?showCaughtException=true");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setBody((Object)"Hello World");
        exchange.setProperty("CamelExceptionCaught", (Object)new IllegalArgumentException("I am caught"));
        Producer producer = endpoint.createProducer();
        producer.start();
        producer.process(exchange);
        producer.stop();
    }

    public void testSendCaughtExchangeWithExceptionAndMultiline() throws Exception {
        Endpoint endpoint = this.resolveMandatoryEndpoint("log:org.apache.camel.TEST?showCaughtException=true&multiline=true");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setBody((Object)"Hello World");
        exchange.setProperty("CamelExceptionCaught", (Object)new IllegalArgumentException("I am caught"));
        Producer producer = endpoint.createProducer();
        producer.start();
        producer.process(exchange);
        producer.stop();
    }

    public void testSendExchangeWithExceptionAndStackTrace() throws Exception {
        Endpoint endpoint = this.resolveMandatoryEndpoint("log:org.apache.camel.TEST?showException=true&showStackTrace=true");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setBody((Object)"Hello World");
        exchange.setException((Throwable)new IllegalArgumentException("Damn"));
        Producer producer = endpoint.createProducer();
        producer.start();
        producer.process(exchange);
        producer.stop();
    }

    public void testSendCaughtExchangeWithExceptionAndStackTrace() throws Exception {
        Endpoint endpoint = this.resolveMandatoryEndpoint("log:org.apache.camel.TEST?showCaughtException=true&showStackTrace=true");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setBody((Object)"Hello World");
        exchange.setProperty("CamelExceptionCaught", (Object)new IllegalArgumentException("I am caught"));
        Producer producer = endpoint.createProducer();
        producer.start();
        producer.process(exchange);
        producer.stop();
    }

    public void testConfiguration() {
        DefaultExchangeFormatter formatter = new DefaultExchangeFormatter();
        DefaultExchangeFormatterTest.assertFalse((boolean)formatter.isShowExchangeId());
        DefaultExchangeFormatterTest.assertFalse((boolean)formatter.isShowProperties());
        DefaultExchangeFormatterTest.assertFalse((boolean)formatter.isShowHeaders());
        DefaultExchangeFormatterTest.assertTrue((boolean)formatter.isShowBodyType());
        DefaultExchangeFormatterTest.assertTrue((boolean)formatter.isShowBody());
        DefaultExchangeFormatterTest.assertFalse((boolean)formatter.isShowOut());
        DefaultExchangeFormatterTest.assertFalse((boolean)formatter.isShowException());
        DefaultExchangeFormatterTest.assertFalse((boolean)formatter.isShowCaughtException());
        DefaultExchangeFormatterTest.assertFalse((boolean)formatter.isShowStackTrace());
        DefaultExchangeFormatterTest.assertFalse((boolean)formatter.isShowAll());
        DefaultExchangeFormatterTest.assertFalse((boolean)formatter.isMultiline());
        DefaultExchangeFormatterTest.assertEquals((int)10000, (int)formatter.getMaxChars());
    }

    private static class MyFuture
    extends FutureTask<String> {
        public MyFuture(Callable<String> callable) {
            super(callable);
        }

        public MyFuture(Runnable runnable, String o) {
            super(runnable, o);
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public String get() throws InterruptedException, ExecutionException {
            return "foo";
        }

        @Override
        public String toString() {
            return "ThisIsMyFuture";
        }
    }
}

