/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class FilerProducerAbsoluteTest
extends ContextTestSupport {
    private String path;

    @Override
    protected void setUp() throws Exception {
        File dir = new File("target/reports/absolute");
        this.path = dir.getAbsolutePath();
        FilerProducerAbsoluteTest.deleteDirectory(dir);
        super.setUp();
    }

    public void testProduceAbsoluteFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.path + "/hello.txt");
        this.template.sendBodyAndHeader("direct:report", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:report").to(new String[]{"file://" + FilerProducerAbsoluteTest.this.path, "mock:result"});
            }
        };
    }
}

