/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;

public class FilerConsumerDualDoneFileNameTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FilerConsumerDualDoneFileNameTest.deleteDirectory("target/done");
        super.setUp();
    }

    public void testTwoDoneFile() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World"});
        this.template.sendBodyAndHeader("file:target/done?doneFileName=${file:name}.ready", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file:target/done?doneFileName=${file:name}.ready", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.assertMockEndpointsSatisfied();
    }

    public void testOneDoneFileMissing() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file:target/done?doneFileName=${file:name}.ready", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file:target/done", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        Thread.sleep(250L);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file:target/done?doneFileName=${file:name}.ready&initialDelay=0&delay=10").to("mock:result");
            }
        };
    }
}

