/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.file.GenericFileOperationFailedException;

public class FileProducerAllowNullBodyTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileProducerAllowNullBodyTest.deleteDirectory("target/allow");
        super.setUp();
    }

    public void testAllowNullBodyTrue() throws Exception {
        this.template.sendBody("file://target/allow?allowNullBody=true&fileName=allowNullBody.txt", null);
        FileProducerAllowNullBodyTest.assertFileExists("target/allow/allowNullBody.txt");
    }

    public void testAllowNullBodyFalse() throws Exception {
        try {
            this.template.sendBody("file://target/allow?fileName=allowNullBody.txt", null);
            FileProducerAllowNullBodyTest.fail((String)"Should have thrown a GenericFileOperationFailedException");
        }
        catch (CamelExecutionException e) {
            GenericFileOperationFailedException cause = FileProducerAllowNullBodyTest.assertIsInstanceOf(GenericFileOperationFailedException.class, e.getCause());
            FileProducerAllowNullBodyTest.assertTrue((boolean)cause.getMessage().endsWith("allowNullBody.txt"));
        }
        FileProducerAllowNullBodyTest.assertFalse((String)"allowNullBody set to false with null body should not create a new file", (boolean)new File("target/allow/allowNullBody.txt").exists());
    }
}

