/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;

public class FileContentBasedRouterTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileContentBasedRouterTest.deleteDirectory("target/cbr");
        super.setUp();
    }

    private void sendFiles() {
        this.template.sendBodyAndHeader("file://target/cbr", (Object)"Hello London", "CamelFileName", (Object)"london.txt");
        this.template.sendBodyAndHeader("file://target/cbr", (Object)"Hello Paris", "CamelFileName", (Object)"paris.txt");
        this.template.sendBodyAndHeader("file://target/cbr", (Object)"Hello Copenhagen", "CamelFileName", (Object)"copenhagen.txt");
    }

    public void testRouteLondon() throws Exception {
        this.sendFiles();
        MockEndpoint mock = this.getMockEndpoint("mock:london");
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).body()).isInstanceOf(GenericFile.class);
        this.assertMockEndpointsSatisfied();
    }

    public void testRouteParis() throws Exception {
        this.sendFiles();
        MockEndpoint mock = this.getMockEndpoint("mock:paris");
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).body()).isInstanceOf(GenericFile.class);
        this.assertMockEndpointsSatisfied();
    }

    public void testRouteOther() throws Exception {
        this.sendFiles();
        MockEndpoint mock = this.getMockEndpoint("mock:other");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("CamelFileName", (Object)"copenhagen.txt");
        ((ValueBuilder)mock.message(0).body()).isInstanceOf(GenericFile.class);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)this.from("file://target/cbr?noop=true").choice().when(this.header("CamelFileName").isEqualTo((Object)"london.txt")).to("mock:london")).when(this.header("CamelFileName").isEqualTo((Object)"paris.txt")).to("mock:paris")).otherwise().to("mock:other");
            }
        };
    }
}

