/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;

public class FileConsumerRestartNotLeakThreadTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumerRestartNotLeakThreadTest.deleteDirectory("target/leak");
        super.setUp();
    }

    public void testLeak() throws Exception {
        int before = Thread.activeCount();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBodyAndHeader("file:target/leak", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        for (int i = 0; i < 50; ++i) {
            this.context.stopRoute("foo");
            this.context.startRoute("foo");
        }
        this.resetMocks();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBodyAndHeader("file:target/leak", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.assertMockEndpointsSatisfied();
        int active = Thread.activeCount() - before;
        this.log.info("Active threads after restarts: {}", (Object)active);
        FileConsumerRestartNotLeakThreadTest.assertTrue((String)("There should not be so many active threads, was " + active), (active < 10 ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file:target/leak").routeId("foo").to("mock:foo");
            }
        };
    }
}

