/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerIncludeNameTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumerIncludeNameTest.deleteDirectory("target/include");
        super.setUp();
    }

    public void testIncludePreAndPostfixes() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.expectedBodiesReceived(new Object[]{"Reports", "Reports"});
        this.sendFiles();
        mock.assertIsSatisfied();
    }

    private void sendFiles() throws Exception {
        String url = "file://target/include";
        this.template.sendBodyAndHeader(url, (Object)"Hello World", "CamelFileName", (Object)"hello.xml");
        this.template.sendBodyAndHeader(url, (Object)"Reports", "CamelFileName", (Object)"report1.txt");
        this.template.sendBodyAndHeader(url, (Object)"Bye World", "CamelFileName", (Object)"secret.txt");
        this.template.sendBodyAndHeader(url, (Object)"Reports", "CamelFileName", (Object)"report2.txt");
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/include/?include=^report.*txt$").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

