/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;

public class FileConsumerIdempotentTest
extends ContextTestSupport {
    private String uri = "file://target/idempotent/?idempotent=true&move=done/${file:name}&delay=10";

    @Override
    protected void setUp() throws Exception {
        FileConsumerIdempotentTest.deleteDirectory("target/idempotent");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/idempotent", (Object)"Hello World", "CamelFileName", (Object)"report.txt");
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileConsumerIdempotentTest.this.uri).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    public void testIdempotent() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        mock.reset();
        mock.expectedMessageCount(0);
        File file = new File("target/idempotent/done/report.txt");
        File renamed = new File("target/idempotent/report.txt");
        file.renameTo(renamed);
        Thread.sleep(100L);
        this.assertMockEndpointsSatisfied();
        FileEndpoint fe = (FileEndpoint)this.context.getEndpoint(this.uri, FileEndpoint.class);
        FileConsumerIdempotentTest.assertNotNull((Object)fe);
        MemoryIdempotentRepository repo = (MemoryIdempotentRepository)fe.getInProgressRepository();
        FileConsumerIdempotentTest.assertEquals((String)"Should be no in-progress files", (int)0, (int)repo.getCacheSize());
    }
}

