/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerDeleteAndFailureTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumerDeleteAndFailureTest.deleteDirectory("target/failed");
        super.setUp();
    }

    public void testMoveFailed() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World IS processed!"});
        mock.expectedFileExists("target/failed/error/bye.txt");
        this.template.sendBodyAndHeader("file://target/failed", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file://target/failed", (Object)"Kabom", "CamelFileName", (Object)"bye.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(IllegalArgumentException.class).useOriginalMessage().to("file://target/failed/error");
                ((RouteDefinition)((RouteDefinition)this.from("file://target/failed?delete=true").setBody((Expression)this.simple("${body} IS processed!"))).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if (body != null && body.startsWith("Kabom")) {
                            throw new IllegalArgumentException("Forced");
                        }
                    }
                })).to("mock:result");
            }
        };
    }
}

