/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumeMoveRelativeNameTest
extends ContextTestSupport {
    private String fileUrl = "file://target/multidir/?recursive=true&move=.done/${file:name}.old";

    @Override
    protected void setUp() throws Exception {
        FileConsumeMoveRelativeNameTest.deleteDirectory("target/multidir");
        super.setUp();
    }

    public void testMultiDir() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Bye World", "Hello World", "Goodday World"});
        mock.expectedFileExists("target/multidir/.done/bye.txt.old");
        mock.expectedFileExists("target/multidir/.done/sub/hello.txt.old");
        mock.expectedFileExists("target/multidir/.done/sub/sub2/goodday.txt.old");
        this.template.sendBodyAndHeader(this.fileUrl, (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader(this.fileUrl, (Object)"Hello World", "CamelFileName", (Object)"sub/hello.txt");
        this.template.sendBodyAndHeader(this.fileUrl, (Object)"Goodday World", "CamelFileName", (Object)"sub/sub2/goodday.txt");
        this.context.startRoute("foo");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileConsumeMoveRelativeNameTest.this.fileUrl).routeId("foo").noAutoStartup().convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

