/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.spi.BrowsableEndpoint;

public class FileBrowsableEndpointTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileBrowsableEndpointTest.deleteDirectory("target/browse");
        super.setUp();
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testBrowsableNoFiles() throws Exception {
        BrowsableEndpoint browse = (BrowsableEndpoint)this.context.getEndpoint("file:target/browse", BrowsableEndpoint.class);
        FileBrowsableEndpointTest.assertNotNull((Object)browse);
        List list = browse.getExchanges();
        FileBrowsableEndpointTest.assertNotNull((Object)list);
        FileBrowsableEndpointTest.assertEquals((int)0, (int)list.size());
    }

    public void testBrowsableOneFile() throws Exception {
        this.template.sendBodyAndHeader("file:target/browse", (Object)"A", "CamelFileName", (Object)"a.txt");
        FileEndpoint endpoint = (FileEndpoint)this.context.getEndpoint("file:target/browse", FileEndpoint.class);
        FileBrowsableEndpointTest.assertNotNull((Object)endpoint);
        MemoryIdempotentRepository repo = (MemoryIdempotentRepository)endpoint.getInProgressRepository();
        FileBrowsableEndpointTest.assertEquals((int)0, (int)repo.getCacheSize());
        List list = endpoint.getExchanges();
        FileBrowsableEndpointTest.assertNotNull((Object)list);
        FileBrowsableEndpointTest.assertEquals((int)1, (int)list.size());
        FileBrowsableEndpointTest.assertEquals((Object)"a.txt", (Object)((Exchange)list.get(0)).getIn().getHeader("CamelFileName"));
        FileBrowsableEndpointTest.assertEquals((int)0, (int)repo.getCacheSize());
        File file = new File("target/browse/a.txt");
        FileBrowsableEndpointTest.assertTrue((String)("File should exist " + file), (boolean)file.exists());
    }

    public void testBrowsableTwoFiles() throws Exception {
        this.template.sendBodyAndHeader("file:target/browse", (Object)"A", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader("file:target/browse", (Object)"B", "CamelFileName", (Object)"b.txt");
        FileEndpoint endpoint = (FileEndpoint)this.context.getEndpoint("file:target/browse?sortBy=file:name", FileEndpoint.class);
        FileBrowsableEndpointTest.assertNotNull((Object)endpoint);
        MemoryIdempotentRepository repo = (MemoryIdempotentRepository)endpoint.getInProgressRepository();
        FileBrowsableEndpointTest.assertEquals((int)0, (int)repo.getCacheSize());
        List list = endpoint.getExchanges();
        FileBrowsableEndpointTest.assertNotNull((Object)list);
        FileBrowsableEndpointTest.assertEquals((int)2, (int)list.size());
        FileBrowsableEndpointTest.assertEquals((Object)"a.txt", (Object)((Exchange)list.get(0)).getIn().getHeader("CamelFileName"));
        FileBrowsableEndpointTest.assertEquals((Object)"b.txt", (Object)((Exchange)list.get(1)).getIn().getHeader("CamelFileName"));
        FileBrowsableEndpointTest.assertEquals((int)0, (int)repo.getCacheSize());
        File fileA = new File("target/browse/a.txt");
        FileBrowsableEndpointTest.assertTrue((String)("File should exist " + fileA), (boolean)fileA.exists());
        File fileB = new File("target/browse/b.txt");
        FileBrowsableEndpointTest.assertTrue((String)("File should exist " + fileB), (boolean)fileB.exists());
    }

    public void testBrowsableThreeFilesRecursive() throws Exception {
        this.template.sendBodyAndHeader("file:target/browse", (Object)"A", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader("file:target/browse", (Object)"B", "CamelFileName", (Object)"foo/b.txt");
        this.template.sendBodyAndHeader("file:target/browse", (Object)"C", "CamelFileName", (Object)"bar/c.txt");
        FileEndpoint endpoint = (FileEndpoint)this.context.getEndpoint("file:target/browse?recursive=true&sortBy=file:name", FileEndpoint.class);
        FileBrowsableEndpointTest.assertNotNull((Object)endpoint);
        MemoryIdempotentRepository repo = (MemoryIdempotentRepository)endpoint.getInProgressRepository();
        FileBrowsableEndpointTest.assertEquals((int)0, (int)repo.getCacheSize());
        List list = endpoint.getExchanges();
        FileBrowsableEndpointTest.assertNotNull((Object)list);
        FileBrowsableEndpointTest.assertEquals((int)3, (int)list.size());
        FileBrowsableEndpointTest.assertEquals((Object)"a.txt", (Object)((Exchange)list.get(0)).getIn().getHeader("CamelFileName"));
        FileBrowsableEndpointTest.assertEquals((Object)"c.txt", (Object)((Exchange)list.get(1)).getIn().getHeader("CamelFileNameOnly"));
        FileBrowsableEndpointTest.assertEquals((Object)"b.txt", (Object)((Exchange)list.get(2)).getIn().getHeader("CamelFileNameOnly"));
        FileBrowsableEndpointTest.assertEquals((int)0, (int)repo.getCacheSize());
        File fileA = new File("target/browse/a.txt");
        FileBrowsableEndpointTest.assertTrue((String)("File should exist " + fileA), (boolean)fileA.exists());
        File fileB = new File("target/browse/foo/b.txt");
        FileBrowsableEndpointTest.assertTrue((String)("File should exist " + fileB), (boolean)fileB.exists());
        File fileC = new File("target/browse/bar/c.txt");
        FileBrowsableEndpointTest.assertTrue((String)("File should exist " + fileC), (boolean)fileC.exists());
    }
}

