/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataformat;

import java.util.List;
import java.util.Map;
import org.apache.camel.ComponentConfiguration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.component.dataformat.DataFormatComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.util.JsonSchemaHelper;
import org.junit.Test;

public class DataFormatComponentConfigurationAndDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testComponentConfiguration() throws Exception {
        DataFormatComponent comp = (DataFormatComponent)this.context.getComponent("dataformat", DataFormatComponent.class);
        EndpointConfiguration conf = comp.createConfiguration("dataformaat:marshal:string?charset=iso-8859-1");
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((Object)"iso-8859-1", (Object)conf.getParameter("charset"));
        ComponentConfiguration compConf = comp.createComponentConfiguration();
        String json = compConf.createParameterJsonSchema();
        DataFormatComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        DataFormatComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"name\": { \"kind\": \"path\", \"required\": \"true\", \"type\": \"string\", \"javaType\": \"java.lang.String\", \"deprecated\": \"false\", \"description\": \"Name of data format\" }"));
        DataFormatComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"operation\": { \"kind\": \"path\", \"required\": \"true\", \"type\": \"string\""));
        DataFormatComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"synchronous\": { \"kind\": \"parameter\", \"type\": \"boolean\""));
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("dataformat");
        DataFormatComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated HTML", (Object)html);
    }

    @Test
    public void testFlatpackDefaultValue() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String json = context.getEipParameterJsonSchema("flatpack");
        DataFormatComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        DataFormatComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"name\": \"flatpack"));
        DataFormatComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"textQualifier\": { \"kind\": \"attribute\", \"required\": \"false\", \"type\": \"string\", \"javaType\": \"java.lang.String\", \"deprecated\": \"false\", \"defaultValue\": \"\\\"\""));
        List rows = JsonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((int)9, (int)rows.size());
        Map found = null;
        for (Map row : rows) {
            if (!"textQualifier".equals(row.get("name"))) continue;
            found = row;
            break;
        }
        DataFormatComponentConfigurationAndDocumentationTest.assertNotNull(found);
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((String)"textQualifier", (String)((String)found.get("name")));
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((String)"attribute", (String)((String)found.get("kind")));
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((String)"false", (String)((String)found.get("required")));
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((String)"string", (String)((String)found.get("type")));
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((String)"java.lang.String", (String)((String)found.get("javaType")));
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((String)"false", (String)((String)found.get("deprecated")));
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((String)"\"", (String)((String)found.get("defaultValue")));
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((String)"If the text is qualified with a char such as \"", (String)((String)found.get("description")));
    }

    @Test
    public void testUniVocityTsvEscapeChar() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String json = context.getEipParameterJsonSchema("univocity-tsv");
        DataFormatComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        DataFormatComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"name\": \"univocity-tsv"));
        DataFormatComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"escapeChar\": { \"kind\": \"attribute\", \"required\": \"false\", \"type\": \"string\", \"javaType\": \"java.lang.String\", \"deprecated\": \"false\", \"defaultValue\": \"\\\\\", \"description\": \"The escape character.\""));
        List rows = JsonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((int)15, (int)rows.size());
        Map found = null;
        for (Map row : rows) {
            if (!"escapeChar".equals(row.get("name"))) continue;
            found = row;
            break;
        }
        DataFormatComponentConfigurationAndDocumentationTest.assertNotNull(found);
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((String)"escapeChar", (String)((String)found.get("name")));
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((String)"attribute", (String)((String)found.get("kind")));
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((String)"false", (String)((String)found.get("required")));
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((String)"string", (String)((String)found.get("type")));
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((String)"java.lang.String", (String)((String)found.get("javaType")));
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((String)"false", (String)((String)found.get("deprecated")));
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((String)"\\", (String)((String)found.get("defaultValue")));
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((String)"The escape character.", (String)((String)found.get("description")));
    }
}

