/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.pojomessage;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.PojoProxyHelper;
import org.apache.camel.component.bean.pojomessage.Person;
import org.junit.Test;

public class PojoProxyHelperRequestReplyTest
extends ContextTestSupport {
    PersonReceiver receiver = new PersonReceiver();

    @Test
    public void testRequestReply() throws Exception {
        Endpoint personEndpoint = this.context.getEndpoint("direct:person");
        Person person = new Person("Chris");
        PersonHandler sender = (PersonHandler)PojoProxyHelper.createProxy((Endpoint)personEndpoint, (Class[])new Class[]{PersonHandler.class});
        Person resultPerson = sender.onPerson(person);
        PojoProxyHelperRequestReplyTest.assertEquals((String)(person.getName() + "1"), (String)resultPerson.getName());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:person").bean((Object)PojoProxyHelperRequestReplyTest.this.receiver);
            }
        };
    }

    public static interface PersonHandler {
        public Person onPerson(Person var1);
    }

    public final class PersonReceiver
    implements PersonHandler {
        @Override
        public Person onPerson(Person person) {
            return new Person(person.getName() + "1");
        }
    }
}

