/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Handler;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.language.Simple;
import org.apache.camel.processor.BeanRouteTest;
import org.apache.camel.util.jndi.JndiContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionAnnotationToDisambiguateMethodsTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BeanRouteTest.class);
    protected MyBean myBean = new MyBean();
    protected MyOtherBean myOtherBean = new MyOtherBean();

    public void testSendMessage() throws Exception {
        this.template.sendBodyAndHeader("direct:in", (Object)"<hello>world!</hello>", "foo", (Object)"bar");
        ExpressionAnnotationToDisambiguateMethodsTest.assertEquals((String)("bean body: " + this.myBean), (String)"bar", (String)this.myBean.bar);
    }

    public void testSendMessageHandler() throws Exception {
        this.template.sendBodyAndHeader("direct:other", (Object)"<hello>world!</hello>", "foo", (Object)"bar");
        ExpressionAnnotationToDisambiguateMethodsTest.assertEquals((String)("bean body: " + this.myOtherBean), (String)"bar", (String)this.myOtherBean.bar);
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        answer.bind("myOtherBean", (Object)this.myOtherBean);
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").beanRef("myBean");
                this.from("direct:other").beanRef("myOtherBean");
            }
        };
    }

    public static class MyOtherBean {
        public String bar;

        public void bar(String body) {
            TestCase.fail((String)("bar() called with: " + body));
        }

        @Handler
        public void foo(@Simple(value="${header.foo}") String bar) {
            this.bar = bar;
            LOG.info("foo() method called with: " + bar);
        }

        public void wrongMethod(String body) {
            TestCase.fail((String)("wrongMethod() called with: " + body));
        }
    }

    public static class MyBean {
        public String bar;

        public void bar(String body) {
            TestCase.fail((String)("bar() called with: " + body));
        }

        public void foo(@Simple(value="${header.foo}") String bar) {
            this.bar = bar;
            LOG.info("foo() method called with: " + bar);
        }

        public void wrongMethod(String body) {
            TestCase.fail((String)("wrongMethod() called with: " + body));
        }
    }
}

