/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.jndi.JndiContext;

public class BeanWithHeaderTest
extends ContextTestSupport {
    public void testBeanWithHeader() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"StartMyBeanMyBean"});
        mock.expectedHeaderReceived("foo", (Object)"bar");
        mock.expectedHeaderReceived("user", (Object)"admin");
        this.template.requestBody("direct:in", (Object)"Start");
        mock.assertIsSatisfied();
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)new MyBean());
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:in").setHeader("foo", (Expression)this.constant("bar"))).to("bean:myBean")).to("seda:a");
                ((RouteDefinition)this.from("seda:a").to("bean:myBean")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public void doSomething(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            exchange.getIn().setHeader("user", (Object)"admin");
            exchange.getIn().setBody((Object)(body + "MyBean"));
        }
    }
}

