/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Date;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.bean.OrderServiceBean;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.w3c.dom.Document;

public class BeanNoTypeConvertionPossibleTest
extends ContextTestSupport {
    public void testBeanNoTypeConvertionPossibleFail() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.requestBody("direct:start", (Object)new Date());
            BeanNoTypeConvertionPossibleTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            NoTypeConversionAvailableException ntae = BeanNoTypeConvertionPossibleTest.assertIsInstanceOf(NoTypeConversionAvailableException.class, e.getCause().getCause());
            BeanNoTypeConvertionPossibleTest.assertEquals(Date.class, (Object)ntae.getFromType());
            BeanNoTypeConvertionPossibleTest.assertEquals(Document.class, (Object)ntae.getToType());
            BeanNoTypeConvertionPossibleTest.assertNotNull((Object)ntae.getValue());
            BeanNoTypeConvertionPossibleTest.assertNotNull((Object)ntae.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testBeanNoTypeConvertionPossibleOK() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"77889,667,457"});
        this.template.requestBody("direct:start", (Object)"<foo>bar</foo>");
        this.assertMockEndpointsSatisfied();
    }

    public void testBeanNoTypeConvertionPossibleOKNullBody() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).body()).isNull();
        Object body = null;
        this.template.requestBody("direct:start", body);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                OrderServiceBean bean = new OrderServiceBean();
                bean.setConverter(BeanNoTypeConvertionPossibleTest.this.context.getTypeConverter());
                ((RouteDefinition)this.from("direct:start").bean((Object)bean, "handleXML")).to("mock:result");
            }
        };
    }
}

