/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import junit.framework.TestCase;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.util.jndi.JndiContext;

public class BeanLookupUsingJndiRegistryIssueTest
extends TestCase {
    public void testCamelWithJndi() throws Exception {
        JndiContext jndi = new JndiContext();
        jndi.bind("foo", (Object)new MyOtherDummyBean());
        DefaultCamelContext camel = new DefaultCamelContext((Context)jndi);
        camel.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").beanRef("foo");
            }
        });
        camel.start();
        String reply = (String)camel.createProducerTemplate().requestBody("direct:start", (Object)"Camel", String.class);
        BeanLookupUsingJndiRegistryIssueTest.assertEquals((String)"Hello Camel", (String)reply);
        camel.stop();
    }

    private static class MyOtherDummyBean {
        private MyOtherDummyBean() {
        }

        public String hello(String s) {
            return "Hello " + s;
        }
    }
}

