/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.http.handlers;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.component.netty4.http.ContextPathMatcher;
import org.apache.camel.component.netty4.http.HttpServerConsumerChannelFactory;
import org.apache.camel.component.netty4.http.NettyHttpConsumer;
import org.apache.camel.component.netty4.http.RestContextPathMatcher;
import org.apache.camel.component.netty4.http.handlers.HttpServerChannelHandler;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpServerMultiplexChannelHandler
extends SimpleChannelInboundHandler<Object>
implements HttpServerConsumerChannelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpConsumer.class);
    private static final AttributeKey<HttpServerChannelHandler> SERVER_HANDLER_KEY = AttributeKey.valueOf((String)"serverHandler");
    private final ConcurrentMap<ContextPathMatcher, HttpServerChannelHandler> consumers = new ConcurrentHashMap<ContextPathMatcher, HttpServerChannelHandler>();
    private int port;
    private String token;
    private int len;

    @Override
    public void init(int port) {
        this.port = port;
        this.token = ":" + port;
        this.len = this.token.length();
    }

    @Override
    public void addConsumer(NettyHttpConsumer consumer) {
        String rawPath = consumer.getConfiguration().getPath();
        String path = HttpServerMultiplexChannelHandler.pathAsKey(consumer.getConfiguration().getPath());
        RestContextPathMatcher matcher = new RestContextPathMatcher(rawPath, path, consumer.getEndpoint().getHttpMethodRestrict(), consumer.getConfiguration().isMatchOnUriPrefix());
        this.consumers.put(matcher, new HttpServerChannelHandler(consumer));
    }

    @Override
    public void removeConsumer(NettyHttpConsumer consumer) {
        String rawPath = consumer.getConfiguration().getPath();
        String path = HttpServerMultiplexChannelHandler.pathAsKey(consumer.getConfiguration().getPath());
        RestContextPathMatcher matcher = new RestContextPathMatcher(rawPath, path, consumer.getEndpoint().getHttpMethodRestrict(), consumer.getConfiguration().isMatchOnUriPrefix());
        this.consumers.remove(matcher);
    }

    @Override
    public int consumers() {
        return this.consumers.size();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public ChannelHandler getChannelHandler() {
        return this;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        HttpRequest request = (HttpRequest)msg;
        LOG.debug("Message received: {}", (Object)request);
        HttpServerChannelHandler handler = this.getHandler(request);
        if (handler != null) {
            Attribute attr = ctx.attr(SERVER_HANDLER_KEY);
            attr.set((Object)handler);
            if (msg instanceof HttpContent) {
                HttpContent httpContent = (HttpContent)msg;
                httpContent.content().retain();
            }
            handler.channelRead(ctx, request);
        } else {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            response.headers().set("Content-Type", (Object)"text/plain");
            response.headers().set("Content-Length", (Object)0);
            ctx.writeAndFlush((Object)response);
            ctx.close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Attribute attr = ctx.attr(SERVER_HANDLER_KEY);
        HttpServerChannelHandler handler = (HttpServerChannelHandler)((Object)attr.get());
        if (handler != null) {
            handler.exceptionCaught(ctx, cause);
        } else {
            if (cause instanceof ClosedChannelException) {
                LOG.debug("Channel already closed. Ignoring this exception.");
                return;
            }
            LOG.warn("HttpServerChannelHandler is not found as attachment to handle exception, send 404 back to the client.", cause);
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            response.headers().set("Content-Type", (Object)"text/plain");
            response.headers().set("Content-Length", (Object)0);
            ctx.writeAndFlush((Object)response);
            ctx.close();
        }
    }

    private HttpServerChannelHandler getHandler(HttpRequest request) {
        HttpServerChannelHandler answer = null;
        String method = request.getMethod().name();
        if (method == null) {
            return null;
        }
        String path = request.getUri();
        int idx = path.indexOf(this.token);
        if (idx > -1) {
            path = path.substring(idx + this.len);
        }
        path = HttpServerMultiplexChannelHandler.pathAsKey(path);
        ArrayList candidates = new ArrayList();
        for (Map.Entry entry : this.consumers.entrySet()) {
            NettyHttpConsumer nettyHttpConsumer = ((HttpServerChannelHandler)((Object)entry.getValue())).getConsumer();
            String restrict = nettyHttpConsumer.getEndpoint().getHttpMethodRestrict();
            if (!((ContextPathMatcher)entry.getKey()).matchMethod(method, restrict)) continue;
            candidates.add(entry);
        }
        LinkedList<HttpServerChannelHandler> directMatches = new LinkedList<HttpServerChannelHandler>();
        for (Map.Entry entry : candidates) {
            if (!((ContextPathMatcher)entry.getKey()).matchesRest(path, false)) continue;
            directMatches.add((HttpServerChannelHandler)((Object)entry.getValue()));
        }
        if (directMatches.size() == 1) {
            answer = (HttpServerChannelHandler)((Object)directMatches.get(0));
        } else if (directMatches.size() > 1) {
            List<HttpServerChannelHandler> directMatchesWithOptions = HttpServerMultiplexChannelHandler.handlersWithExplicitOptionsMethod(directMatches);
            answer = !directMatchesWithOptions.isEmpty() ? HttpServerMultiplexChannelHandler.handlerWithTheLongestMatchingPrefix(directMatchesWithOptions) : HttpServerMultiplexChannelHandler.handlerWithTheLongestMatchingPrefix(directMatches);
        }
        if (answer == null) {
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                if (((ContextPathMatcher)entry.getKey()).matchesRest(path, true)) continue;
                it.remove();
            }
            int n = Integer.MAX_VALUE;
            Map.Entry best = null;
            if (candidates.size() > 1) {
                for (Map.Entry entry : candidates) {
                    int n2;
                    String consumerPath = ((HttpServerChannelHandler)((Object)entry.getValue())).getConsumer().getConfiguration().getPath();
                    int wildcards = HttpServerMultiplexChannelHandler.countWildcards(consumerPath);
                    if (wildcards <= 0 || best != null && wildcards >= n2) continue;
                    best = entry;
                    n2 = wildcards;
                }
                if (best != null) {
                    answer = (HttpServerChannelHandler)((Object)best.getValue());
                }
            }
            if (answer == null && candidates.size() == 1) {
                answer = (HttpServerChannelHandler)((Object)((Map.Entry)candidates.get(0)).getValue());
            }
        }
        if (answer == null) {
            for (Map.Entry entry : this.consumers.entrySet()) {
                if (!((ContextPathMatcher)entry.getKey()).matches(path)) continue;
                answer = (HttpServerChannelHandler)((Object)entry.getValue());
                break;
            }
        }
        return answer;
    }

    private static int countWildcards(String consumerPath) {
        String[] consumerPaths;
        int wildcards = 0;
        if (consumerPath.startsWith("/")) {
            consumerPath = consumerPath.substring(1);
        }
        if (consumerPath.endsWith("/")) {
            consumerPath = consumerPath.substring(0, consumerPath.length() - 1);
        }
        for (String p2 : consumerPaths = consumerPath.split("/")) {
            if (!p2.startsWith("{") || !p2.endsWith("}")) continue;
            ++wildcards;
        }
        return wildcards;
    }

    private static String pathAsKey(String path) {
        int idx;
        if (path == null || path.equals("/")) {
            path = "";
        }
        if ((idx = path.indexOf(63)) > -1) {
            path = path.substring(0, idx);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return UnsafeUriCharactersEncoder.encodeHttpURI((String)path);
    }

    private static List<HttpServerChannelHandler> handlersWithExplicitOptionsMethod(Iterable<HttpServerChannelHandler> handlers) {
        LinkedList<HttpServerChannelHandler> handlersWithOptions = new LinkedList<HttpServerChannelHandler>();
        for (HttpServerChannelHandler handler : handlers) {
            String consumerMethod = handler.getConsumer().getEndpoint().getHttpMethodRestrict();
            if (consumerMethod == null || !consumerMethod.contains("OPTIONS")) continue;
            handlersWithOptions.add(handler);
        }
        return handlersWithOptions;
    }

    private static HttpServerChannelHandler handlerWithTheLongestMatchingPrefix(Iterable<HttpServerChannelHandler> handlers) {
        HttpServerChannelHandler handlerWithTheLongestPrefix = handlers.iterator().next();
        for (HttpServerChannelHandler handler : handlers) {
            String consumerPath = handler.getConsumer().getConfiguration().getPath();
            String longestPath = handlerWithTheLongestPrefix.getConsumer().getConfiguration().getPath();
            if (consumerPath.length() <= longestPath.length()) continue;
            handlerWithTheLongestPrefix = handler;
        }
        return handlerWithTheLongestPrefix;
    }
}

