/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.internal;

import com.box.boxjavalibv2.BoxClient;
import org.apache.camel.component.box.internal.CachingSecureStorage;
import org.apache.camel.component.box.internal.OAuthHelperListener;
import org.apache.http.conn.ClientConnectionManager;

public class CachedBoxClient {
    private final BoxClient boxClient;
    private final String login;
    private final String clientId;
    private final CachingSecureStorage secureStorage;
    private final OAuthHelperListener listener;
    private final ClientConnectionManager[] clientConnectionManager;

    public CachedBoxClient(BoxClient boxClient, String login, String clientId, CachingSecureStorage secureStorage, OAuthHelperListener listener, ClientConnectionManager[] clientConnectionManager) {
        this.boxClient = boxClient;
        this.login = login;
        this.clientId = clientId;
        this.secureStorage = secureStorage;
        this.listener = listener;
        if (clientConnectionManager == null || clientConnectionManager.length != 1) {
            throw new IllegalArgumentException("clientConnectionManager must be an array of length 1");
        }
        this.clientConnectionManager = clientConnectionManager;
    }

    public BoxClient getBoxClient() {
        return this.boxClient;
    }

    public CachingSecureStorage getSecureStorage() {
        return this.secureStorage;
    }

    public OAuthHelperListener getListener() {
        return this.listener;
    }

    public ClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager[0];
    }

    public String toString() {
        return String.format("{login:%s, client_id:%s}", this.login, this.clientId);
    }
}

