/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker.producer;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.AttachContainerCmd;
import com.github.dockerjava.api.command.AuthCmd;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.CommitCmd;
import com.github.dockerjava.api.command.ContainerDiffCmd;
import com.github.dockerjava.api.command.CopyFileFromContainerCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateImageCmd;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.InfoCmd;
import com.github.dockerjava.api.command.InspectContainerCmd;
import com.github.dockerjava.api.command.InspectImageCmd;
import com.github.dockerjava.api.command.KillContainerCmd;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.command.PauseContainerCmd;
import com.github.dockerjava.api.command.PingCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.command.RemoveContainerCmd;
import com.github.dockerjava.api.command.RemoveImageCmd;
import com.github.dockerjava.api.command.RestartContainerCmd;
import com.github.dockerjava.api.command.SearchImagesCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.command.StopContainerCmd;
import com.github.dockerjava.api.command.TagImageCmd;
import com.github.dockerjava.api.command.TopContainerCmd;
import com.github.dockerjava.api.command.UnpauseContainerCmd;
import com.github.dockerjava.api.command.VersionCmd;
import com.github.dockerjava.api.command.WaitContainerCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.ExposedPorts;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.LxcConf;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.Volumes;
import java.io.File;
import java.io.InputStream;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.docker.DockerClientFactory;
import org.apache.camel.component.docker.DockerComponent;
import org.apache.camel.component.docker.DockerConfiguration;
import org.apache.camel.component.docker.DockerEndpoint;
import org.apache.camel.component.docker.DockerHelper;
import org.apache.camel.component.docker.DockerOperation;
import org.apache.camel.component.docker.exception.DockerException;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerProducer
extends DefaultProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerProducer.class);
    private DockerConfiguration configuration;
    private DockerComponent component;

    public DockerProducer(DockerEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.configuration = endpoint.getConfiguration();
        this.component = (DockerComponent)endpoint.getComponent();
    }

    public void process(Exchange exchange) throws Exception {
        AuthCmd dockerCmd = null;
        Message message = exchange.getIn();
        DockerClient client = DockerClientFactory.getDockerClient(this.component, this.configuration, message);
        DockerOperation operation = this.configuration.getOperation();
        switch (operation) {
            case AUTH: {
                dockerCmd = this.executeAuthRequest(client, message);
                break;
            }
            case INFO: {
                dockerCmd = this.executeInfoRequest(client, message);
                break;
            }
            case PING: {
                dockerCmd = this.executePingRequest(client, message);
                break;
            }
            case VERSION: {
                dockerCmd = this.executeVersionRequest(client, message);
                break;
            }
            case BUILD_IMAGE: {
                dockerCmd = this.executeBuildImageRequest(client, message);
                break;
            }
            case CREATE_IMAGE: {
                dockerCmd = this.executeCreateImageRequest(client, message);
                break;
            }
            case INSPECT_IMAGE: {
                dockerCmd = this.executeInspectImageRequest(client, message);
                break;
            }
            case LIST_IMAGES: {
                dockerCmd = this.executeListImagesRequest(client, message);
                break;
            }
            case PULL_IMAGE: {
                dockerCmd = this.executePullImageRequest(client, message);
                break;
            }
            case PUSH_IMAGE: {
                dockerCmd = this.executePushImageRequest(client, message);
                break;
            }
            case REMOVE_IMAGE: {
                dockerCmd = this.executeRemoveImageRequest(client, message);
                break;
            }
            case SEARCH_IMAGES: {
                dockerCmd = this.executeSearchImageRequest(client, message);
                break;
            }
            case TAG_IMAGE: {
                dockerCmd = this.executeTagImageRequest(client, message);
                break;
            }
            case ATTACH_CONTAINER: {
                dockerCmd = this.executeAttachContainerRequest(client, message);
                break;
            }
            case COMMIT_CONTAINER: {
                dockerCmd = this.executeCommitContainerRequest(client, message);
                break;
            }
            case COPY_FILE_CONTAINER: {
                dockerCmd = this.executeCopyFileContainerRequest(client, message);
                break;
            }
            case CREATE_CONTAINER: {
                dockerCmd = this.executeCreateContainerRequest(client, message);
                break;
            }
            case DIFF_CONTAINER: {
                dockerCmd = this.executeDiffContainerRequest(client, message);
                break;
            }
            case INSPECT_CONTAINER: {
                dockerCmd = this.executeInspectContainerRequest(client, message);
                break;
            }
            case LIST_CONTAINERS: {
                dockerCmd = this.executeListContainersRequest(client, message);
                break;
            }
            case LOG_CONTAINER: {
                dockerCmd = this.executeLogContainerRequest(client, message);
                break;
            }
            case KILL_CONTAINER: {
                dockerCmd = this.executeKillContainerRequest(client, message);
                break;
            }
            case PAUSE_CONTAINER: {
                dockerCmd = this.executePauseContainerRequest(client, message);
                break;
            }
            case REMOVE_CONTAINER: {
                dockerCmd = this.executeRemoveContainerRequest(client, message);
                break;
            }
            case RESTART_CONTAINER: {
                dockerCmd = this.executeRestartContainerRequest(client, message);
                break;
            }
            case START_CONTAINER: {
                dockerCmd = this.executeStartContainerRequest(client, message);
                break;
            }
            case STOP_CONTAINER: {
                dockerCmd = this.executeStopContainerRequest(client, message);
                break;
            }
            case TOP_CONTAINER: {
                dockerCmd = this.executeTopContainerRequest(client, message);
                break;
            }
            case UNPAUSE_CONTAINER: {
                dockerCmd = this.executeUnpauseContainerRequest(client, message);
                break;
            }
            case WAIT_CONTAINER: {
                dockerCmd = this.executeWaitContainerRequest(client, message);
                break;
            }
            case EXEC_CREATE: {
                dockerCmd = this.executeExecCreateRequest(client, message);
                break;
            }
            case EXEC_START: {
                dockerCmd = this.executeExecStartRequest(client, message);
                break;
            }
            default: {
                throw new DockerException("Invalid operation: " + (Object)((Object)operation));
            }
        }
        Object result = dockerCmd.exec();
        if (result != null) {
            exchange.getIn().setBody(result);
        }
    }

    private AuthCmd executeAuthRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Auth Request");
        AuthCmd authCmd = client.authCmd();
        AuthConfig authConfig = client.authConfig();
        if (authCmd != null) {
            authCmd.withAuthConfig(authConfig);
        }
        return authCmd;
    }

    private InfoCmd executeInfoRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Info Request");
        InfoCmd infoCmd = client.infoCmd();
        return infoCmd;
    }

    private PingCmd executePingRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Ping Request");
        PingCmd pingCmd = client.pingCmd();
        return pingCmd;
    }

    private VersionCmd executeVersionRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Version Request");
        VersionCmd versionCmd = client.versionCmd();
        return versionCmd;
    }

    private BuildImageCmd executeBuildImageRequest(DockerClient client, Message message) throws DockerException {
        String tag;
        Boolean remove;
        Boolean quiet;
        BuildImageCmd buildImageCmd;
        LOGGER.debug("Executing Docker Build Image Request");
        Object body = message.getBody();
        if (body != null && body instanceof InputStream) {
            buildImageCmd = client.buildImageCmd((InputStream)body);
        } else if (body != null && body instanceof File) {
            buildImageCmd = client.buildImageCmd((File)body);
        } else {
            throw new DockerException("Unable to location source Image");
        }
        Boolean noCache = DockerHelper.getProperty("CamelDockerNoCache", this.configuration, message, Boolean.class);
        if (noCache != null) {
            buildImageCmd.withNoCache(noCache.booleanValue());
        }
        if ((quiet = DockerHelper.getProperty("CamelDockerQuiet", this.configuration, message, Boolean.class)) != null) {
            buildImageCmd.withQuiet(quiet.booleanValue());
        }
        if ((remove = DockerHelper.getProperty("CamelDockerRemove", this.configuration, message, Boolean.class)) != null) {
            buildImageCmd.withRemove(remove.booleanValue());
        }
        if ((tag = DockerHelper.getProperty("CamelDockerTag", this.configuration, message, String.class)) != null) {
            buildImageCmd.withTag(tag);
        }
        return buildImageCmd;
    }

    private CreateImageCmd executeCreateImageRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Create Image Request");
        String repository = DockerHelper.getProperty("CamelDockerRepository", this.configuration, message, String.class);
        InputStream inputStream = (InputStream)message.getBody(InputStream.class);
        if (repository == null || inputStream == null) {
            throw new IllegalArgumentException("Inputstream must be present on message body and repository must be specified");
        }
        CreateImageCmd createImageCmd = client.createImageCmd(repository, inputStream);
        return createImageCmd;
    }

    private InspectImageCmd executeInspectImageRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Inspect Image Request");
        String imageId = DockerHelper.getProperty("CamelDockerImageId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)imageId, (String)"Image ID must be specified");
        InspectImageCmd inspectImageCmd = client.inspectImageCmd(imageId);
        return inspectImageCmd;
    }

    private ListImagesCmd executeListImagesRequest(DockerClient client, Message message) {
        Boolean showAll;
        LOGGER.debug("Executing Docker Images List Request");
        ListImagesCmd listImagesCmd = client.listImagesCmd();
        String filter = DockerHelper.getProperty("CamelDockerFilter", this.configuration, message, String.class);
        if (filter != null) {
            listImagesCmd.withFilters(filter);
        }
        if ((showAll = DockerHelper.getProperty("CamelDockerShowAll", this.configuration, message, Boolean.class)) != null) {
            listImagesCmd.withShowAll(showAll.booleanValue());
        }
        return listImagesCmd;
    }

    private PullImageCmd executePullImageRequest(DockerClient client, Message message) {
        AuthConfig authConfig;
        String tag;
        LOGGER.debug("Executing Docker Pull Image Request");
        String repository = DockerHelper.getProperty("CamelDockerRepository", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)repository, (String)"Repository must be specified");
        PullImageCmd pullImageCmd = client.pullImageCmd(repository);
        String registry = DockerHelper.getProperty("CamelDockerRegistry", this.configuration, message, String.class);
        if (registry != null) {
            pullImageCmd.withRegistry(registry);
        }
        if ((tag = DockerHelper.getProperty("CamelDockerTag", this.configuration, message, String.class)) != null) {
            pullImageCmd.withTag(tag);
        }
        if ((authConfig = client.authConfig()) != null) {
            pullImageCmd.withAuthConfig(authConfig);
        }
        return pullImageCmd;
    }

    private PushImageCmd executePushImageRequest(DockerClient client, Message message) {
        AuthConfig authConfig;
        LOGGER.debug("Executing Docker Push Image Request");
        String name = DockerHelper.getProperty("CamelDockerName", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)name, (String)"Image name must be specified");
        PushImageCmd pushImageCmd = client.pushImageCmd(name);
        String tag = DockerHelper.getProperty("CamelDockerTag", this.configuration, message, String.class);
        if (tag != null) {
            pushImageCmd.withTag(tag);
        }
        if ((authConfig = client.authConfig()) != null) {
            pushImageCmd.withAuthConfig(authConfig);
        }
        return pushImageCmd;
    }

    private RemoveImageCmd executeRemoveImageRequest(DockerClient client, Message message) {
        Boolean noPrune;
        LOGGER.debug("Executing Docker Remove Image Request");
        String imageId = DockerHelper.getProperty("CamelDockerImageId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)imageId, (String)"Image ID must be specified");
        RemoveImageCmd removeImagesCmd = client.removeImageCmd(imageId);
        Boolean force = DockerHelper.getProperty("CamelDockerForce", this.configuration, message, Boolean.class);
        if (force != null) {
            removeImagesCmd.withForce();
        }
        if ((noPrune = DockerHelper.getProperty("CamelDockerNoPrune", this.configuration, message, Boolean.class)) != null) {
            removeImagesCmd.withNoPrune(noPrune.booleanValue());
        }
        return removeImagesCmd;
    }

    private SearchImagesCmd executeSearchImageRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Search Image Request");
        String term = DockerHelper.getProperty("CamelDockerTerm", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)term, (String)"Term must be specified");
        SearchImagesCmd searchImagesCmd = client.searchImagesCmd(term);
        return searchImagesCmd;
    }

    private TagImageCmd executeTagImageRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Tag Image Request");
        String imageId = DockerHelper.getProperty("CamelDockerImageId", this.configuration, message, String.class);
        String repository = DockerHelper.getProperty("CamelDockerRepository", this.configuration, message, String.class);
        String tag = DockerHelper.getProperty("CamelDockerTag", this.configuration, message, String.class);
        if (imageId == null || repository == null || tag == null) {
            throw new IllegalArgumentException("ImageId, repository and tag must be specified");
        }
        TagImageCmd tagImageCmd = client.tagImageCmd(imageId, repository, tag);
        Boolean force = DockerHelper.getProperty("CamelDockerForce", this.configuration, message, Boolean.class);
        if (force != null) {
            tagImageCmd.withForce(force.booleanValue());
        }
        return tagImageCmd;
    }

    private AttachContainerCmd executeAttachContainerRequest(DockerClient client, Message message) {
        Boolean timestamps;
        Boolean stdOut;
        Boolean stdErr;
        Boolean logs;
        LOGGER.debug("Executing Docker Attach Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        AttachContainerCmd attachContainerCmd = client.attachContainerCmd(containerId);
        Boolean followStream = DockerHelper.getProperty("CamelDockerFollowStream", this.configuration, message, Boolean.class);
        if (followStream != null) {
            attachContainerCmd.withFollowStream(followStream.booleanValue());
        }
        if ((logs = DockerHelper.getProperty("CamelDockerLogs", this.configuration, message, Boolean.class)) != null) {
            attachContainerCmd.withLogs(logs.booleanValue());
        }
        if ((stdErr = DockerHelper.getProperty("CamelDockerStdErr", this.configuration, message, Boolean.class)) != null) {
            attachContainerCmd.withStdErr(stdErr.booleanValue());
        }
        if ((stdOut = DockerHelper.getProperty("CamelDockerStdOut", this.configuration, message, Boolean.class)) != null) {
            attachContainerCmd.withStdOut(stdOut.booleanValue());
        }
        if ((timestamps = DockerHelper.getProperty("CamelDockerTimestamps", this.configuration, message, Boolean.class)) != null) {
            attachContainerCmd.withTimestamps(timestamps.booleanValue());
        }
        return attachContainerCmd;
    }

    private CommitCmd executeCommitContainerRequest(DockerClient client, Message message) throws DockerException {
        String workingDir;
        Volumes volumes;
        String user;
        Boolean tty;
        String tag;
        Boolean stdInOnce;
        String repository;
        String[] portSpecs;
        Boolean pause;
        Boolean openStdIn;
        String msg;
        Integer memorySwap;
        Integer memory;
        String hostname;
        ExposedPorts exposedPorts;
        String[] envs;
        Boolean disableNetwork;
        String[] cmds;
        Boolean attachStdOut;
        Boolean attachStdIn;
        Boolean attachStdErr;
        LOGGER.debug("Executing Docker Commit Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        CommitCmd commitCmd = client.commitCmd(containerId);
        String author = DockerHelper.getProperty("CamelDockerAuthor", this.configuration, message, String.class);
        if (author != null) {
            commitCmd.withAuthor(author);
        }
        if ((attachStdErr = DockerHelper.getProperty("CamelDockerAttachStdErr", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withAttachStderr(attachStdErr.booleanValue());
        }
        if ((attachStdIn = DockerHelper.getProperty("CamelDockerAttachStdIn", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withAttachStdin(attachStdIn.booleanValue());
        }
        if ((attachStdOut = DockerHelper.getProperty("CamelDockerAttachStdOut", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withAttachStdout(attachStdOut.booleanValue());
        }
        if ((cmds = DockerHelper.parseDelimitedStringHeader("CamelDockerCmd", message)) != null) {
            commitCmd.withCmd(cmds);
        }
        if ((disableNetwork = DockerHelper.getProperty("CamelDockerDisableNetwork", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withDisableNetwork(disableNetwork.booleanValue());
        }
        if ((envs = DockerHelper.parseDelimitedStringHeader("CamelDockerEnv", message)) != null) {
            commitCmd.withEnv(envs);
        }
        if ((exposedPorts = DockerHelper.getProperty("CamelDockerExposedPorts", this.configuration, message, ExposedPorts.class)) != null) {
            commitCmd.withExposedPorts(exposedPorts);
        }
        if ((hostname = DockerHelper.getProperty("CamelDockerHostname", this.configuration, message, String.class)) != null) {
            commitCmd.withHostname(hostname);
        }
        if ((memory = DockerHelper.getProperty("CamelDockerMemory", this.configuration, message, Integer.class)) != null) {
            commitCmd.withMemory(memory);
        }
        if ((memorySwap = DockerHelper.getProperty("CamelDockerMemorySwap", this.configuration, message, Integer.class)) != null) {
            commitCmd.withMemorySwap(memorySwap);
        }
        if ((msg = DockerHelper.getProperty("CamelDockerMessage", this.configuration, message, String.class)) != null) {
            commitCmd.withMessage(msg);
        }
        if ((openStdIn = DockerHelper.getProperty("CamelDockerOpenStdIn", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withOpenStdin(openStdIn.booleanValue());
        }
        if ((pause = DockerHelper.getProperty("CamelDockerPause", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withPause(pause.booleanValue());
        }
        if ((portSpecs = DockerHelper.parseDelimitedStringHeader("CamelDockerPortSpecs", message)) != null) {
            commitCmd.withPortSpecs(portSpecs);
        }
        if ((repository = DockerHelper.getProperty("CamelDockerRepository", this.configuration, message, String.class)) != null) {
            commitCmd.withRepository(repository);
        }
        if ((stdInOnce = DockerHelper.getProperty("CamelDockerStdInOnce", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withStdinOnce(stdInOnce.booleanValue());
        }
        if ((tag = DockerHelper.getProperty("CamelDockerTag", this.configuration, message, String.class)) != null) {
            commitCmd.withTag(tag);
        }
        if ((tty = DockerHelper.getProperty("CamelDockerTty", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withTty(tty.booleanValue());
        }
        if ((user = DockerHelper.getProperty("CamelDockerUser", this.configuration, message, String.class)) != null) {
            commitCmd.withUser(user);
        }
        if ((volumes = DockerHelper.getProperty("CamelDockerVolumes", this.configuration, message, Volumes.class)) != null) {
            commitCmd.withVolumes(volumes);
        }
        if ((workingDir = DockerHelper.getProperty("CamelDockerWorkingDir", this.configuration, message, String.class)) != null) {
            commitCmd.withWorkingDir(workingDir);
        }
        return commitCmd;
    }

    private CopyFileFromContainerCmd executeCopyFileContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Copy File/Folder Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        String resource = DockerHelper.getProperty("CamelDockerResource", this.configuration, message, String.class);
        if (containerId == null || resource == null) {
            throw new IllegalArgumentException("Container ID and Resource must be specified");
        }
        CopyFileFromContainerCmd copyFileContainerCmd = client.copyFileFromContainerCmd(containerId, resource);
        String hostPath = DockerHelper.getProperty("CamelDockerHostPath", this.configuration, message, String.class);
        if (hostPath != null) {
            copyFileContainerCmd.withHostPath(hostPath);
        }
        return copyFileContainerCmd;
    }

    private CreateContainerCmd executeCreateContainerRequest(DockerClient client, Message message) {
        String workingDir;
        String[] volumesFrom;
        Volume[] volume;
        String user;
        Boolean tty;
        Boolean stdInOnce;
        Boolean stdInOpen;
        String[] portSpecs;
        String name;
        Long memorySwap;
        Long memoryLimit;
        String hostName;
        HostConfig hostConfig;
        ExposedPort[] exposedPorts;
        String[] entrypoint;
        String[] env;
        String[] dns;
        Boolean disableNetwork;
        Integer cpuShares;
        String[] cmd;
        Capability[] capDrop;
        Capability[] capAdd;
        Boolean attachStdOut;
        Boolean attachStdIn;
        LOGGER.debug("Executing Docker Create Container Request");
        String image = DockerHelper.getProperty("CamelDockerImage", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)image, (String)"Image must be specified");
        CreateContainerCmd createContainerCmd = client.createContainerCmd(image);
        Boolean attachStdErr = DockerHelper.getProperty("CamelDockerAttachStdErr", this.configuration, message, Boolean.class);
        if (attachStdErr != null) {
            createContainerCmd.withAttachStderr(attachStdErr.booleanValue());
        }
        if ((attachStdIn = DockerHelper.getProperty("CamelDockerAttachStdIn", this.configuration, message, Boolean.class)) != null) {
            createContainerCmd.withAttachStdin(attachStdIn.booleanValue());
        }
        if ((attachStdOut = DockerHelper.getProperty("CamelDockerAttachStdOut", this.configuration, message, Boolean.class)) != null) {
            createContainerCmd.withAttachStdout(attachStdOut.booleanValue());
        }
        if ((capAdd = DockerHelper.getArrayProperty("CamelDockerCapAdd", message, Capability.class)) != null) {
            createContainerCmd.withCapAdd(capAdd);
        }
        if ((capDrop = DockerHelper.getArrayProperty("CamelDockerCapDrop", message, Capability.class)) != null) {
            createContainerCmd.withCapDrop(capDrop);
        }
        if ((cmd = DockerHelper.parseDelimitedStringHeader("CamelDockerCmd", message)) != null) {
            createContainerCmd.withCmd(cmd);
        }
        if ((cpuShares = DockerHelper.getProperty("CamelDockerCpuShares", this.configuration, message, Integer.class)) != null) {
            createContainerCmd.withCpuShares(cpuShares.intValue());
        }
        if ((disableNetwork = DockerHelper.getProperty("CamelDockerDisableNetwork", this.configuration, message, Boolean.class)) != null) {
            createContainerCmd.withDisableNetwork(disableNetwork.booleanValue());
        }
        if ((dns = DockerHelper.parseDelimitedStringHeader("CamelDockerDns", message)) != null) {
            createContainerCmd.withDns(dns);
        }
        if ((env = DockerHelper.parseDelimitedStringHeader("CamelDockerEnv", message)) != null) {
            createContainerCmd.withEnv(env);
        }
        if ((entrypoint = DockerHelper.getArrayProperty("CamelDockerEntryPoint", message, String.class)) != null) {
            createContainerCmd.withEntrypoint(entrypoint);
        }
        if ((exposedPorts = DockerHelper.getArrayProperty("CamelDockerExposedPorts", message, ExposedPort.class)) != null) {
            createContainerCmd.withExposedPorts(exposedPorts);
        }
        if ((hostConfig = DockerHelper.getProperty("CamelDockerHostConfig", this.configuration, message, HostConfig.class)) != null) {
            createContainerCmd.withHostConfig(hostConfig);
        }
        if ((hostName = DockerHelper.getProperty("CamelDockerHostname", this.configuration, message, String.class)) != null) {
            createContainerCmd.withHostName(hostName);
        }
        if ((memoryLimit = DockerHelper.getProperty("CamelDockerMemoryLimit", this.configuration, message, Long.class)) != null) {
            createContainerCmd.withMemoryLimit(memoryLimit.longValue());
        }
        if ((memorySwap = DockerHelper.getProperty("CamelDockerMemorySwap", this.configuration, message, Long.class)) != null) {
            createContainerCmd.withMemorySwap(memorySwap.longValue());
        }
        if ((name = DockerHelper.getProperty("CamelDockerName", this.configuration, message, String.class)) != null) {
            createContainerCmd.withName(name);
        }
        if ((portSpecs = DockerHelper.parseDelimitedStringHeader("CamelDockerPortSpecs", message)) != null) {
            createContainerCmd.withPortSpecs(portSpecs);
        }
        if ((stdInOpen = DockerHelper.getProperty("CamelDockerStdInOpen", this.configuration, message, Boolean.class)) != null) {
            createContainerCmd.withStdinOpen(stdInOpen.booleanValue());
        }
        if ((stdInOnce = DockerHelper.getProperty("CamelDockerStdInOnce", this.configuration, message, Boolean.class)) != null) {
            createContainerCmd.withStdInOnce(stdInOnce.booleanValue());
        }
        if ((tty = DockerHelper.getProperty("CamelDockerTty", this.configuration, message, Boolean.class)) != null) {
            createContainerCmd.withTty(tty.booleanValue());
        }
        if ((user = DockerHelper.getProperty("CamelDockerUser", this.configuration, message, String.class)) != null) {
            createContainerCmd.withUser(user);
        }
        if ((volume = DockerHelper.getArrayProperty("CamelDockerVolumes", message, Volume.class)) != null) {
            createContainerCmd.withVolumes(volume);
        }
        if ((volumesFrom = DockerHelper.parseDelimitedStringHeader("CamelDockerVolumesFrom", message)) != null) {
            createContainerCmd.withVolumesFrom(volumesFrom);
        }
        if ((workingDir = DockerHelper.getProperty("CamelDockerWorkingDir", this.configuration, message, String.class)) != null) {
            createContainerCmd.withWorkingDir(workingDir);
        }
        return createContainerCmd;
    }

    private ContainerDiffCmd executeDiffContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Diff Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        ContainerDiffCmd diffContainerCmd = client.containerDiffCmd(containerId);
        String containerIdDiff = DockerHelper.getProperty("CamelDockerContainerIdDiff", this.configuration, message, String.class);
        if (containerIdDiff != null) {
            diffContainerCmd.withContainerId(containerIdDiff);
        }
        return diffContainerCmd;
    }

    private InspectContainerCmd executeInspectContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Inspect Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        InspectContainerCmd inspectContainerCmd = client.inspectContainerCmd(containerId);
        return inspectContainerCmd;
    }

    private KillContainerCmd executeKillContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Kill Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        KillContainerCmd killContainerCmd = client.killContainerCmd(containerId);
        String signal = DockerHelper.getProperty("CamelDockerSignal", this.configuration, message, String.class);
        if (signal != null) {
            killContainerCmd.withSignal(signal);
        }
        return killContainerCmd;
    }

    private ListContainersCmd executeListContainersRequest(DockerClient client, Message message) {
        String since;
        Boolean showSize;
        Boolean showAll;
        Integer limit;
        LOGGER.debug("Executing Docker List Container Request");
        ListContainersCmd listContainersCmd = client.listContainersCmd();
        String before = DockerHelper.getProperty("CamelDockerBefore", this.configuration, message, String.class);
        if (before != null) {
            listContainersCmd.withBefore(before);
        }
        if ((limit = DockerHelper.getProperty("CamelDockerLimit", this.configuration, message, Integer.class)) != null) {
            listContainersCmd.withLimit(limit.intValue());
        }
        if ((showAll = DockerHelper.getProperty("CamelDockerShowAll", this.configuration, message, Boolean.class)) != null) {
            listContainersCmd.withShowAll(showAll.booleanValue());
        }
        if ((showSize = DockerHelper.getProperty("CamelDockerShowSize", this.configuration, message, Boolean.class)) != null) {
            listContainersCmd.withShowSize(showSize.booleanValue());
        }
        if ((since = DockerHelper.getProperty("CamelDockerSince", this.configuration, message, String.class)) != null) {
            listContainersCmd.withSince(since);
        }
        return listContainersCmd;
    }

    private LogContainerCmd executeLogContainerRequest(DockerClient client, Message message) {
        Boolean timestamps;
        Boolean tailAll;
        Integer tail;
        Boolean stdOut;
        Boolean stdErr;
        LOGGER.debug("Executing Docker Log Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        LogContainerCmd logContainerCmd = client.logContainerCmd(containerId);
        Boolean followStream = DockerHelper.getProperty("CamelDockerFollowStream", this.configuration, message, Boolean.class);
        if (followStream != null) {
            logContainerCmd.withFollowStream(followStream.booleanValue());
        }
        if ((stdErr = DockerHelper.getProperty("CamelDockerStdErr", this.configuration, message, Boolean.class)) != null) {
            logContainerCmd.withStdErr(stdErr.booleanValue());
        }
        if ((stdOut = DockerHelper.getProperty("CamelDockerStdOut", this.configuration, message, Boolean.class)) != null) {
            logContainerCmd.withStdOut(stdOut.booleanValue());
        }
        if ((tail = DockerHelper.getProperty("CamelDockerTail", this.configuration, message, Integer.class)) != null) {
            logContainerCmd.withTail(tail.intValue());
        }
        if ((tailAll = DockerHelper.getProperty("CamelDockerTailAll", this.configuration, message, Boolean.class)) != null && tailAll.booleanValue()) {
            logContainerCmd.withTailAll();
        }
        if ((timestamps = DockerHelper.getProperty("CamelDockerTimestamps", this.configuration, message, Boolean.class)) != null) {
            logContainerCmd.withTimestamps(timestamps.booleanValue());
        }
        return logContainerCmd;
    }

    private PauseContainerCmd executePauseContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Pause Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        PauseContainerCmd pauseContainerCmd = client.pauseContainerCmd(containerId);
        return pauseContainerCmd;
    }

    private RemoveContainerCmd executeRemoveContainerRequest(DockerClient client, Message message) {
        Boolean removeVolumes;
        LOGGER.debug("Executing Docker Remove Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        RemoveContainerCmd removeContainerCmd = client.removeContainerCmd(containerId);
        Boolean force = DockerHelper.getProperty("CamelDockerForce", this.configuration, message, Boolean.class);
        if (force != null) {
            removeContainerCmd.withForce(force.booleanValue());
        }
        if ((removeVolumes = DockerHelper.getProperty("CamelDockerRemoveVolumes", this.configuration, message, Boolean.class)) != null) {
            removeContainerCmd.withRemoveVolumes(removeVolumes.booleanValue());
        }
        return removeContainerCmd;
    }

    private RestartContainerCmd executeRestartContainerRequest(DockerClient client, Message message) throws DockerException {
        LOGGER.debug("Executing Docker Restart Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        RestartContainerCmd restartContainerCmd = client.restartContainerCmd(containerId);
        Integer timeout = DockerHelper.getProperty("CamelDockerTimeout", this.configuration, message, Integer.class);
        if (timeout != null) {
            restartContainerCmd.withtTimeout(timeout.intValue());
        }
        return restartContainerCmd;
    }

    private StartContainerCmd executeStartContainerRequest(DockerClient client, Message message) {
        String volumesFrom;
        RestartPolicy restartPolicy;
        Boolean publishAllPorts;
        Boolean privileged;
        PortBinding[] portBinding;
        Ports ports;
        String networkMode;
        LxcConf[] lxcConf;
        Link[] links;
        String[] dnsSearch;
        String[] dns;
        Device[] devices;
        Capability[] capDrop;
        Capability[] capAdd;
        LOGGER.debug("Executing Docker Start Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        StartContainerCmd startContainerCmd = client.startContainerCmd(containerId);
        Bind[] binds = DockerHelper.getArrayProperty("CamelDockerBinds", message, Bind.class);
        if (binds != null) {
            startContainerCmd.withBinds(binds);
        }
        if ((capAdd = DockerHelper.getArrayProperty("CamelDockerCapAdd", message, Capability.class)) != null) {
            startContainerCmd.withCapAdd(capAdd);
        }
        if ((capDrop = DockerHelper.getArrayProperty("CamelDockerCapDrop", message, Capability.class)) != null) {
            startContainerCmd.withCapDrop(capDrop);
        }
        if ((devices = DockerHelper.getArrayProperty("CamelDockeDevices", message, Device.class)) != null) {
            startContainerCmd.withDevices(devices);
        }
        if ((dns = DockerHelper.parseDelimitedStringHeader("CamelDockerDns", message)) != null) {
            startContainerCmd.withDns(dns);
        }
        if ((dnsSearch = DockerHelper.parseDelimitedStringHeader("CamelDockerDnsSearch", message)) != null) {
            startContainerCmd.withDnsSearch(dnsSearch);
        }
        if ((links = DockerHelper.getArrayProperty("CamelDockerLinks", message, Link.class)) != null) {
            startContainerCmd.withLinks(links);
        }
        if ((lxcConf = DockerHelper.getArrayProperty("CamelDockerLxcConf", message, LxcConf.class)) != null) {
            startContainerCmd.withLxcConf(lxcConf);
        }
        if ((networkMode = DockerHelper.getProperty("CamelNetworkMode", this.configuration, message, String.class)) != null) {
            startContainerCmd.withNetworkMode(networkMode);
        }
        if ((ports = DockerHelper.getProperty("CamelDockerPorts", this.configuration, message, Ports.class)) != null) {
            startContainerCmd.withPortBindings(ports);
        }
        if ((portBinding = DockerHelper.getArrayProperty("CamelDockerPortBinding", message, PortBinding.class)) != null) {
            startContainerCmd.withPortBindings(portBinding);
        }
        if ((privileged = DockerHelper.getProperty("CamelDockerDnsPrivileged", this.configuration, message, Boolean.class)) != null) {
            startContainerCmd.withPrivileged(privileged);
        }
        if ((publishAllPorts = DockerHelper.getProperty("CamelDockerPublishAllPorts", this.configuration, message, Boolean.class)) != null) {
            startContainerCmd.withPublishAllPorts(publishAllPorts);
        }
        if ((restartPolicy = DockerHelper.getProperty("CamelDockerRestartPolicy", this.configuration, message, RestartPolicy.class)) != null) {
            startContainerCmd.withRestartPolicy(restartPolicy);
        }
        if ((volumesFrom = DockerHelper.getProperty("CamelDockerVolumesFrom", this.configuration, message, String.class)) != null) {
            startContainerCmd.withVolumesFrom(volumesFrom);
        }
        return startContainerCmd;
    }

    private StopContainerCmd executeStopContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Kill Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        StopContainerCmd stopContainerCmd = client.stopContainerCmd(containerId);
        Integer timeout = DockerHelper.getProperty("CamelDockerTimeout", this.configuration, message, Integer.class);
        if (timeout != null) {
            stopContainerCmd.withTimeout(timeout.intValue());
        }
        return stopContainerCmd;
    }

    private TopContainerCmd executeTopContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Top Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        TopContainerCmd topContainerCmd = client.topContainerCmd(containerId);
        String psArgs = DockerHelper.getProperty("CamelDockerPsArgs", this.configuration, message, String.class);
        if (psArgs != null) {
            topContainerCmd.withPsArgs(psArgs);
        }
        return topContainerCmd;
    }

    private UnpauseContainerCmd executeUnpauseContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Unpause Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        UnpauseContainerCmd unpauseContainerCmd = client.unpauseContainerCmd(containerId);
        return unpauseContainerCmd;
    }

    private WaitContainerCmd executeWaitContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Wait Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        WaitContainerCmd waitContainerCmd = client.waitContainerCmd(containerId);
        return waitContainerCmd;
    }

    private ExecCreateCmd executeExecCreateRequest(DockerClient client, Message message) {
        Boolean tty;
        String[] cmd;
        Boolean attachStdOut;
        LOGGER.debug("Executing Docker Exec Create Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        ExecCreateCmd execCreateCmd = client.execCreateCmd(containerId);
        Boolean attachStdIn = DockerHelper.getProperty("CamelDockerAttachStdIn", this.configuration, message, Boolean.class);
        Boolean attachStdErr = DockerHelper.getProperty("CamelDockerAttachStdErr", this.configuration, message, Boolean.class);
        if (attachStdErr != null) {
            execCreateCmd.withAttachStderr(attachStdErr.booleanValue());
        }
        if (attachStdIn != null) {
            execCreateCmd.withAttachStdin(attachStdIn.booleanValue());
        }
        if ((attachStdOut = DockerHelper.getProperty("CamelDockerAttachStdOut", this.configuration, message, Boolean.class)) != null) {
            execCreateCmd.withAttachStdout(attachStdOut.booleanValue());
        }
        if ((cmd = DockerHelper.parseDelimitedStringHeader("CamelDockerCmd", message)) != null) {
            execCreateCmd.withCmd(cmd);
        }
        if ((tty = DockerHelper.getProperty("CamelDockerTty", this.configuration, message, Boolean.class)) != null) {
            execCreateCmd.withTty(tty.booleanValue());
        }
        return execCreateCmd;
    }

    private ExecStartCmd executeExecStartRequest(DockerClient client, Message message) {
        Boolean tty;
        LOGGER.debug("Executing Docker Exec Create Request");
        String execId = DockerHelper.getProperty("CamelDockerExecId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)execId, (String)"Exec ID must be specified");
        ExecStartCmd execStartCmd = client.execStartCmd(execId);
        Boolean detach = DockerHelper.getProperty("CamelDockerDetach", this.configuration, message, Boolean.class);
        if (detach != null) {
            execStartCmd.withDetach(detach.booleanValue());
        }
        if ((tty = DockerHelper.getProperty("CamelDockerTty", this.configuration, message, Boolean.class)) != null) {
            execStartCmd.withTty(tty.booleanValue());
        }
        return execStartCmd;
    }

    protected void doStop() throws Exception {
        super.doStop();
    }
}

