/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.splunk;

import com.splunk.Args;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.splunk.ProducerType;
import org.apache.camel.component.splunk.SplunkEndpoint;
import org.apache.camel.component.splunk.event.SplunkEvent;
import org.apache.camel.component.splunk.support.DataWriter;
import org.apache.camel.component.splunk.support.StreamDataWriter;
import org.apache.camel.component.splunk.support.SubmitDataWriter;
import org.apache.camel.component.splunk.support.TcpDataWriter;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplunkProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(SplunkProducer.class);
    private SplunkEndpoint endpoint;
    private DataWriter dataWriter;

    public SplunkProducer(SplunkEndpoint endpoint, ProducerType producerType) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.createWriter(producerType);
    }

    public void process(Exchange exchange) throws Exception {
        try {
            if (!this.dataWriter.isConnected()) {
                this.dataWriter.start();
            }
            this.dataWriter.write((SplunkEvent)exchange.getIn().getMandatoryBody(SplunkEvent.class));
        }
        catch (Exception e) {
            if (this.endpoint.reset(e)) {
                this.dataWriter.stop();
            }
            throw e;
        }
    }

    protected void doStop() throws Exception {
        this.dataWriter.stop();
        super.doStop();
    }

    private void createWriter(ProducerType producerType) {
        switch (producerType) {
            case TCP: {
                LOG.debug("Creating TcpDataWriter");
                this.dataWriter = new TcpDataWriter(this.endpoint, this.buildSplunkArgs());
                ((TcpDataWriter)this.dataWriter).setPort(this.endpoint.getConfiguration().getTcpReceiverPort());
                LOG.debug("TcpDataWriter created for endpoint {}", (Object)this.endpoint);
                break;
            }
            case SUBMIT: {
                LOG.debug("Creating SubmitDataWriter");
                this.dataWriter = new SubmitDataWriter(this.endpoint, this.buildSplunkArgs());
                ((SubmitDataWriter)this.dataWriter).setIndex(this.endpoint.getConfiguration().getIndex());
                LOG.debug("SubmitDataWriter created for endpoint {}", (Object)this.endpoint);
                break;
            }
            case STREAM: {
                LOG.debug("Creating StreamDataWriter");
                this.dataWriter = new StreamDataWriter(this.endpoint, this.buildSplunkArgs());
                ((StreamDataWriter)this.dataWriter).setIndex(this.endpoint.getConfiguration().getIndex());
                LOG.debug("StreamDataWriter created for endpoint {}", (Object)this.endpoint);
                break;
            }
            default: {
                throw new RuntimeException("unknown producerType");
            }
        }
    }

    private Args buildSplunkArgs() {
        Args args = new Args();
        if (this.endpoint.getConfiguration().getSourceType() != null) {
            args.put((Object)"sourcetype", (Object)this.endpoint.getConfiguration().getSourceType());
        }
        if (this.endpoint.getConfiguration().getSource() != null) {
            args.put((Object)"source", (Object)this.endpoint.getConfiguration().getSource());
        }
        return args;
    }

    protected DataWriter getDataWriter() {
        return this.dataWriter;
    }
}

