/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.component.hbase.HBaseEndpoint;
import org.apache.camel.component.hbase.HBaseHelper;
import org.apache.camel.component.hbase.filters.ModelAwareFilter;
import org.apache.camel.component.hbase.mapping.CellMappingStrategy;
import org.apache.camel.component.hbase.model.HBaseCell;
import org.apache.camel.component.hbase.model.HBaseData;
import org.apache.camel.component.hbase.model.HBaseRow;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseProducer
extends DefaultProducer
implements ServicePoolAware {
    private HBaseEndpoint endpoint;
    private String tableName;
    private final HTablePool tablePool;
    private HBaseRow rowModel;

    public HBaseProducer(HBaseEndpoint endpoint, HTablePool tablePool, String tableName) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.tableName = tableName;
        this.tablePool = tablePool;
        this.rowModel = endpoint.getRowModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        try (HTableInterface table = this.tablePool.getTable(this.tableName.getBytes());){
            this.updateHeaders(exchange);
            String operation = (String)exchange.getIn().getHeader("CamelHBaseOperation");
            Integer maxScanResult = (Integer)exchange.getIn().getHeader("CamelHBaseMaxScanResults", Integer.class);
            String fromRowId = (String)exchange.getIn().getHeader("CamelHBaseStartRow");
            CellMappingStrategy mappingStrategy = this.endpoint.getCellMappingStrategyFactory().getStrategy(exchange.getIn());
            HBaseData data = mappingStrategy.resolveModel(exchange.getIn());
            LinkedList<Put> putOperations = new LinkedList<Put>();
            LinkedList<Delete> deleteOperations = new LinkedList<Delete>();
            LinkedList<HBaseRow> getOperationResult = new LinkedList<HBaseRow>();
            List<HBaseRow> scanOperationResult = new LinkedList<HBaseRow>();
            for (HBaseRow hRow : data.getRows()) {
                hRow.apply(this.rowModel);
                if ("CamelHBasePut".equals(operation)) {
                    putOperations.add(this.createPut(hRow));
                    continue;
                }
                if ("CamelHBaseGet".equals(operation)) {
                    HBaseRow getResultRow = this.getCells(table, hRow);
                    getOperationResult.add(getResultRow);
                    continue;
                }
                if ("CamelHBaseDelete".equals(operation)) {
                    deleteOperations.add(this.createDeleteRow(hRow));
                    continue;
                }
                if (!"CamelHBaseScan".equals(operation)) continue;
                scanOperationResult = this.scanCells(table, hRow, fromRowId, maxScanResult, this.endpoint.getFilters());
            }
            if (!putOperations.isEmpty()) {
                table.put(putOperations);
                table.flushCommits();
            } else if (!deleteOperations.isEmpty()) {
                table.delete(deleteOperations);
            } else if (!getOperationResult.isEmpty()) {
                mappingStrategy.applyGetResults(exchange.getOut(), new HBaseData(getOperationResult));
            } else if (!scanOperationResult.isEmpty()) {
                mappingStrategy.applyScanResults(exchange.getOut(), new HBaseData(scanOperationResult));
            }
        }
    }

    private Put createPut(HBaseRow hRow) throws Exception {
        ObjectHelper.notNull((Object)hRow, (String)"HBase row");
        ObjectHelper.notNull((Object)hRow.getId(), (String)"HBase row id");
        ObjectHelper.notNull(hRow.getCells(), (String)"HBase cells");
        Put put = new Put((byte[])this.endpoint.getCamelContext().getTypeConverter().convertTo(byte[].class, hRow.getId()));
        Set<HBaseCell> cells = hRow.getCells();
        for (HBaseCell cell : cells) {
            String family = cell.getFamily();
            String column = cell.getQualifier();
            Object value = cell.getValue();
            ObjectHelper.notNull((Object)family, (String)"HBase column family", (Object)cell);
            ObjectHelper.notNull((Object)column, (String)"HBase column", (Object)cell);
            put.add(HBaseHelper.getHBaseFieldAsBytes(family), HBaseHelper.getHBaseFieldAsBytes(column), (byte[])this.endpoint.getCamelContext().getTypeConverter().convertTo(byte[].class, value));
        }
        return put;
    }

    private HBaseRow getCells(HTableInterface table, HBaseRow hRow) throws Exception {
        HBaseRow resultRow = new HBaseRow();
        LinkedList<HBaseCell> resultCells = new LinkedList<HBaseCell>();
        ObjectHelper.notNull((Object)hRow, (String)"HBase row");
        ObjectHelper.notNull((Object)hRow.getId(), (String)"HBase row id");
        ObjectHelper.notNull(hRow.getCells(), (String)"HBase cells");
        resultRow.setId(hRow.getId());
        Get get = new Get((byte[])this.endpoint.getCamelContext().getTypeConverter().convertTo(byte[].class, hRow.getId()));
        Set<HBaseCell> cellModels = hRow.getCells();
        for (HBaseCell cellModel : cellModels) {
            String family = cellModel.getFamily();
            String column = cellModel.getQualifier();
            ObjectHelper.notNull((Object)family, (String)"HBase column family", (Object)cellModel);
            ObjectHelper.notNull((Object)column, (String)"HBase column", (Object)cellModel);
            get.addColumn(HBaseHelper.getHBaseFieldAsBytes(family), HBaseHelper.getHBaseFieldAsBytes(column));
        }
        Result result = table.get(get);
        if (!result.isEmpty()) {
            resultRow.setTimestamp(result.raw()[0].getTimestamp());
        }
        for (HBaseCell cellModel : cellModels) {
            HBaseCell resultCell = new HBaseCell();
            String family = cellModel.getFamily();
            String column = cellModel.getQualifier();
            resultCell.setFamily(family);
            resultCell.setQualifier(column);
            List kvs = result.getColumn(HBaseHelper.getHBaseFieldAsBytes(family), HBaseHelper.getHBaseFieldAsBytes(column));
            if (kvs != null && !kvs.isEmpty()) {
                resultCell.setValue(this.endpoint.getCamelContext().getTypeConverter().convertTo(cellModel.getValueType(), (Object)((KeyValue)kvs.get(0)).getValue()));
                resultCell.setTimestamp(((KeyValue)kvs.get(0)).getTimestamp());
            }
            resultCells.add(resultCell);
            resultRow.getCells().add(resultCell);
        }
        return resultRow;
    }

    private Delete createDeleteRow(HBaseRow hRow) throws Exception {
        ObjectHelper.notNull((Object)hRow, (String)"HBase row");
        ObjectHelper.notNull((Object)hRow.getId(), (String)"HBase row id");
        return new Delete((byte[])this.endpoint.getCamelContext().getTypeConverter().convertTo(byte[].class, hRow.getId()));
    }

    private List<HBaseRow> scanCells(HTableInterface table, HBaseRow model, String start, Integer maxRowScan, List<Filter> filters) throws Exception {
        LinkedList<HBaseRow> rowSet = new LinkedList<HBaseRow>();
        HBaseRow startRow = new HBaseRow(model.getCells());
        startRow.setId(start);
        Scan scan = start != null ? new Scan(Bytes.toBytes((String)start)) : new Scan();
        if (filters != null && !filters.isEmpty()) {
            LinkedList<ModelAwareFilter> clonedFilters = new LinkedList<ModelAwareFilter>();
            for (Filter filter : filters) {
                Object clone;
                if (!ModelAwareFilter.class.isAssignableFrom(filter.getClass()) || !((clone = this.endpoint.getCamelContext().getInjector().newInstance(filter.getClass())) instanceof ModelAwareFilter)) continue;
                ((ModelAwareFilter)clone).apply(this.endpoint.getCamelContext(), model);
                clonedFilters.add((ModelAwareFilter)clone);
            }
            scan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, clonedFilters));
        }
        Set<HBaseCell> cellModels = model.getCells();
        for (HBaseCell cellModel : cellModels) {
            String family = cellModel.getFamily();
            String column = cellModel.getQualifier();
            if (!ObjectHelper.isNotEmpty((Object)family) || !ObjectHelper.isNotEmpty((Object)column)) continue;
            scan.addColumn(HBaseHelper.getHBaseFieldAsBytes(family), HBaseHelper.getHBaseFieldAsBytes(column));
        }
        ResultScanner resultScanner = table.getScanner(scan);
        Result result = resultScanner.next();
        for (int count = 0; result != null && count < maxRowScan; ++count) {
            HBaseRow resultRow = new HBaseRow();
            resultRow.setId(this.endpoint.getCamelContext().getTypeConverter().convertTo(model.getRowType(), (Object)result.getRow()));
            resultRow.setTimestamp(result.raw()[0].getTimestamp());
            cellModels = model.getCells();
            for (HBaseCell modelCell : cellModels) {
                HBaseCell resultCell = new HBaseCell();
                String family = modelCell.getFamily();
                String column = modelCell.getQualifier();
                resultRow.setId(this.endpoint.getCamelContext().getTypeConverter().convertTo(model.getRowType(), (Object)result.getRow()));
                resultCell.setValue(this.endpoint.getCamelContext().getTypeConverter().convertTo(modelCell.getValueType(), (Object)result.getValue(HBaseHelper.getHBaseFieldAsBytes(family), HBaseHelper.getHBaseFieldAsBytes(column))));
                resultCell.setFamily(modelCell.getFamily());
                resultCell.setQualifier(modelCell.getQualifier());
                if (result.getColumnLatest(HBaseHelper.getHBaseFieldAsBytes(family), HBaseHelper.getHBaseFieldAsBytes(column)) != null) {
                    resultCell.setTimestamp(result.getColumnLatest(HBaseHelper.getHBaseFieldAsBytes(family), HBaseHelper.getHBaseFieldAsBytes(column)).getTimestamp());
                }
                resultRow.getCells().add(resultCell);
            }
            rowSet.add(resultRow);
            result = resultScanner.next();
        }
        return rowSet;
    }

    private void updateHeaders(Exchange exchange) {
        if (exchange != null && exchange.getIn() != null) {
            if (this.endpoint.getMaxResults() != 0 && exchange.getIn().getHeader("CamelHBaseMaxScanResults") == null) {
                exchange.getIn().setHeader("CamelHBaseMaxScanResults", (Object)this.endpoint.getMaxResults());
            }
            if (this.endpoint.getMappingStrategyName() != null && exchange.getIn().getHeader("CamelMappingStrategy") == null) {
                exchange.getIn().setHeader("CamelMappingStrategy", (Object)this.endpoint.getMappingStrategyName());
            }
            if (this.endpoint.getMappingStrategyName() != null && exchange.getIn().getHeader("CamelMappingStrategyClassName") == null) {
                exchange.getIn().setHeader("CamelMappingStrategyClassName", (Object)this.endpoint.getMappingStrategyClassName());
            }
            if (this.endpoint.getOperation() != null && exchange.getIn().getHeader("CamelHBaseOperation") == null) {
                exchange.getIn().setHeader("CamelHBaseOperation", (Object)this.endpoint.getOperation());
            } else if (this.endpoint.getOperation() == null && exchange.getIn().getHeader("CamelHBaseOperation") == null) {
                exchange.getIn().setHeader("CamelHBaseOperation", (Object)"CamelHBasePut");
            }
        }
    }
}

