/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sparkrest;

import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.sparkrest.CamelSpark;
import org.apache.camel.component.sparkrest.CamelSparkRoute;
import org.apache.camel.component.sparkrest.SparkEndpoint;
import org.apache.camel.impl.DefaultConsumer;

public class SparkConsumer
extends DefaultConsumer {
    private final CamelSparkRoute route;

    public SparkConsumer(Endpoint endpoint, Processor processor, CamelSparkRoute route) {
        super(endpoint, processor);
        this.route = route;
    }

    public SparkEndpoint getEndpoint() {
        return (SparkEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        String verb = this.getEndpoint().getVerb();
        String path = this.getEndpoint().getPath();
        String accept = this.getEndpoint().getAccept();
        if (accept != null) {
            this.log.debug("Spark-rest: {}({}) accepting: {}", new Object[]{verb, path, accept});
        } else {
            this.log.debug("Spark-rest: {}({})", (Object)verb, (Object)path);
        }
        CamelSpark.spark(verb, path, accept, this.route);
    }
}

