/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import java.util.Collection;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.component.hazelcast.HazelcastDefaultProducer;
import org.apache.camel.component.hazelcast.map.HazelcastMapEndpoint;

public class HazelcastMapProducer
extends HazelcastDefaultProducer {
    private final IMap<Object, Object> cache;

    public HazelcastMapProducer(HazelcastInstance hazelcastInstance, HazelcastMapEndpoint endpoint, String cacheName) {
        super(endpoint);
        this.cache = hazelcastInstance.getMap(cacheName);
    }

    public void process(Exchange exchange) throws Exception {
        Map headers = exchange.getIn().getHeaders();
        Object oid = null;
        String query = null;
        if (headers.containsKey("CamelHazelcastObjectId")) {
            oid = headers.get("CamelHazelcastObjectId");
        }
        if (headers.containsKey("CamelHazelcastQuery")) {
            query = (String)headers.get("CamelHazelcastQuery");
        }
        int operation = this.lookupOperationNumber(exchange);
        switch (operation) {
            case 1: {
                this.put(oid, exchange);
                break;
            }
            case 3: {
                this.get(oid, exchange);
                break;
            }
            case 2: {
                this.delete(oid);
                break;
            }
            case 4: {
                this.update(oid, exchange);
                break;
            }
            case 5: {
                this.query(query, exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The value '%s' is not allowed for parameter '%s' on the MAP cache.", operation, "CamelHazelcastOperationType"));
            }
        }
        HazelcastComponentHelper.copyHeaders(exchange);
    }

    private void query(String query, Exchange exchange) {
        Collection result = this.cache.values((Predicate)new SqlPredicate(query));
        exchange.getOut().setBody((Object)result);
    }

    private void update(Object oid, Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.cache.lock(oid);
        this.cache.replace(oid, body);
        this.cache.unlock(oid);
    }

    private void delete(Object oid) {
        this.cache.remove(oid);
    }

    private void get(Object oid, Exchange exchange) {
        exchange.getOut().setBody(this.cache.get(oid));
    }

    private void put(Object oid, Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.cache.put(oid, body);
    }
}

