/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.net.URI;
import java.security.KeyPair;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class SftpConfiguration
extends RemoteFileConfiguration {
    public static final int DEFAULT_SFTP_PORT = 22;
    @UriParam
    private String knownHostsFile;
    @UriParam
    private String knownHostsUri;
    private byte[] knownHosts;
    @UriParam
    private String privateKeyFile;
    @UriParam
    private String privateKeyUri;
    private byte[] privateKey;
    @UriParam
    private String privateKeyPassphrase;
    private KeyPair keyPair;
    @UriParam(defaultValue="no")
    private String strictHostKeyChecking = "no";
    @UriParam
    private int serverAliveInterval;
    @UriParam(defaultValue="1")
    private int serverAliveCountMax = 1;
    @UriParam
    private String chmod;
    @UriParam
    private String ciphers;
    @UriParam
    private int compression;
    @UriParam
    private String preferredAuthentications;
    @UriParam(defaultValue="WARN")
    private LoggingLevel jschLoggingLevel = LoggingLevel.WARN;

    public SftpConfiguration() {
        this.setProtocol("sftp");
    }

    public SftpConfiguration(URI uri) {
        super(uri);
    }

    @Override
    protected void setDefaultPort() {
        this.setPort(22);
    }

    public String getKnownHostsFile() {
        return this.knownHostsFile;
    }

    public void setKnownHostsFile(String knownHostsFile) {
        this.knownHostsFile = knownHostsFile;
    }

    public String getKnownHostsUri() {
        return this.knownHostsUri;
    }

    public void setKnownHostsUri(String knownHostsUri) {
        this.knownHostsUri = knownHostsUri;
    }

    public byte[] getKnownHosts() {
        return this.knownHosts;
    }

    public void setKnownHosts(byte[] knownHosts) {
        this.knownHosts = knownHosts;
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public void setPrivateKeyFile(String privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    public String getPrivateKeyUri() {
        return this.privateKeyUri;
    }

    public void setPrivateKeyUri(String privateKeyUri) {
        this.privateKeyUri = privateKeyUri;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(byte[] privateKey) {
        this.privateKey = privateKey;
    }

    public String getPrivateKeyPassphrase() {
        return this.privateKeyPassphrase;
    }

    public void setPrivateKeyPassphrase(String privateKeyFilePassphrase) {
        this.privateKeyPassphrase = privateKeyFilePassphrase;
    }

    @Deprecated
    public String getPrivateKeyFilePassphrase() {
        return this.privateKeyPassphrase;
    }

    @Deprecated
    public void setPrivateKeyFilePassphrase(String privateKeyFilePassphrase) {
        this.privateKeyPassphrase = privateKeyFilePassphrase;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public void setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public String getStrictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    public void setStrictHostKeyChecking(String strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
    }

    public void setServerAliveInterval(int serverAliveInterval) {
        this.serverAliveInterval = serverAliveInterval;
    }

    public int getServerAliveInterval() {
        return this.serverAliveInterval;
    }

    public void setServerAliveCountMax(int serverAliveCountMax) {
        this.serverAliveCountMax = serverAliveCountMax;
    }

    public int getServerAliveCountMax() {
        return this.serverAliveCountMax;
    }

    public void setChmod(String chmod) {
        this.chmod = chmod;
    }

    public String getChmod() {
        return this.chmod;
    }

    public void setCiphers(String ciphers) {
        this.ciphers = ciphers;
    }

    public String getCiphers() {
        return this.ciphers;
    }

    public int getCompression() {
        return this.compression;
    }

    public void setCompression(int compression) {
        this.compression = compression;
    }

    public void setPreferredAuthentications(String pAuthentications) {
        this.preferredAuthentications = pAuthentications;
    }

    public String getPreferredAuthentications() {
        return this.preferredAuthentications;
    }

    public LoggingLevel getJschLoggingLevel() {
        return this.jschLoggingLevel;
    }

    public void setJschLoggingLevel(LoggingLevel jschLoggingLevel) {
        this.jschLoggingLevel = jschLoggingLevel;
    }
}

