/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.javaspace;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.javaspace.JavaSpaceComponent;
import org.apache.camel.component.javaspace.JavaSpaceConsumer;
import org.apache.camel.component.javaspace.JavaSpaceProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(scheme="javaspace", title="JavaSpace", syntax="javaspace:url", consumerClass=JavaSpaceConsumer.class, label="messaging")
public class JavaSpaceEndpoint
extends DefaultEndpoint {
    private final Map<?, ?> parameters;
    @UriPath
    @Metadata(required="true")
    private final String url;
    @UriParam(defaultValue="1")
    private int concurrentConsumers = 1;
    @UriParam
    private String spaceName;
    @UriParam
    private boolean transactional;
    @UriParam
    private long transactionTimeout = Long.MAX_VALUE;
    @UriParam(defaultValue="take")
    private String verb = "take";
    @UriParam
    private String templateId;

    public JavaSpaceEndpoint(String endpointUri, String remaining, Map<?, ?> parameters, JavaSpaceComponent component) {
        super(endpointUri, (Component)component);
        this.url = remaining;
        this.parameters = parameters;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public String getVerb() {
        return this.verb;
    }

    public void setVerb(String verb) {
        this.verb = verb;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public Producer createProducer() throws Exception {
        return new JavaSpaceProducer(this);
    }

    public DefaultExchange createExchange() {
        return new DefaultExchange(this.getCamelContext(), this.getExchangePattern());
    }

    public boolean isSingleton() {
        return true;
    }

    @Deprecated
    public String getRemaining() {
        return this.url;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<?, ?> getParameters() {
        return this.parameters;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        JavaSpaceConsumer answer = new JavaSpaceConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public long getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(long transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }
}

