/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openshift;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IGear;
import com.openshift.client.IGearGroup;
import com.openshift.client.cartridge.IEmbeddedCartridge;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.openshift.OpenShiftEndpoint;
import org.apache.camel.component.openshift.OpenShiftHelper;
import org.apache.camel.component.openshift.OpenShiftOperation;
import org.apache.camel.impl.DefaultProducer;

public class OpenShiftProducer
extends DefaultProducer {
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public OpenShiftProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public OpenShiftEndpoint getEndpoint() {
        return (OpenShiftEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String openshiftServer = OpenShiftHelper.getOpenShiftServer(this.getEndpoint());
        IDomain domain = OpenShiftHelper.loginAndGetDomain(this.getEndpoint(), openshiftServer);
        if (domain == null) {
            throw new CamelExchangeException("User has no domain with id " + this.getEndpoint().getDomain(), exchange);
        }
        OpenShiftOperation operation = (OpenShiftOperation)((Object)exchange.getIn().getHeader("CamelOpenShiftOperation", (Object)this.getEndpoint().getOperation(), OpenShiftOperation.class));
        switch (operation) {
            case start: {
                this.doStart(exchange, domain);
                break;
            }
            case stop: {
                this.doStop(exchange, domain);
                break;
            }
            case restart: {
                this.doRestart(exchange, domain);
                break;
            }
            case state: {
                this.doState(exchange, domain);
                break;
            }
            default: {
                if (this.getEndpoint().getMode().equals("json")) {
                    this.doListJson(exchange, domain);
                    break;
                }
                this.doListPojo(exchange, domain);
            }
        }
    }

    protected void doListJson(Exchange exchange, IDomain domain) {
        StringBuilder sb = new StringBuilder("{\n  \"applications\": [");
        boolean first = true;
        for (IApplication application : domain.getApplications()) {
            if (!first) {
                sb.append("\n    ],");
            } else {
                first = false;
            }
            String date = new SimpleDateFormat(TIMESTAMP_FORMAT).format(application.getCreationTime());
            sb.append("\n    {");
            sb.append("\n      \"uuid\": \"" + application.getUUID() + "\",");
            sb.append("\n      \"domain\": \"" + application.getDomain().getId() + "\",");
            sb.append("\n      \"name\": \"" + application.getName() + "\",");
            sb.append("\n      \"creationTime\": \"" + date + "\",");
            sb.append("\n      \"applicationUrl\": \"" + application.getApplicationUrl() + "\",");
            sb.append("\n      \"gitUrl\": \"" + application.getGitUrl() + "\",");
            sb.append("\n      \"sshUrl\": \"" + application.getSshUrl() + "\",");
            sb.append("\n      \"catridge\": {");
            sb.append("\n        \"name\": \"" + application.getCartridge().getName() + "\",");
            sb.append("\n        \"displayName\": \"" + application.getCartridge().getDisplayName() + "\",");
            sb.append("\n        \"description\": \"" + application.getCartridge().getDescription() + "\"");
            sb.append("\n      },");
            List embeddedCartridges = application.getEmbeddedCartridges();
            if (embeddedCartridges != null && !embeddedCartridges.isEmpty()) {
                sb.append("\n      \"embeddedCatridges\": [");
                Iterator it = embeddedCartridges.iterator();
                while (it.hasNext()) {
                    IEmbeddedCartridge cartridge = (IEmbeddedCartridge)it.next();
                    sb.append("\n      \"catridge\": {");
                    sb.append("\n        \"name\": \"" + cartridge.getName() + "\",");
                    sb.append("\n        \"displayName\": \"" + cartridge.getDisplayName() + "\",");
                    sb.append("\n        \"description\": \"" + cartridge.getDescription() + "\"");
                    sb.append("\n      }");
                    if (!it.hasNext()) continue;
                    sb.append(",");
                }
                sb.append("\n      ]");
            }
            sb.append("\n      \"gearProfile\": \"" + application.getGearProfile().getName() + "\",");
            sb.append("\n      \"gears\": [");
            boolean firstGear = true;
            for (IGearGroup group : application.getGearGroups()) {
                for (IGear gear : group.getGears()) {
                    if (!firstGear) {
                        sb.append(",");
                    } else {
                        firstGear = false;
                    }
                    sb.append("\n        {");
                    sb.append("\n         \"id\": \"" + gear.getId() + "\",");
                    sb.append("\n         \"sshUrl\": \"" + gear.getSshUrl() + "\",");
                    sb.append("\n         \"state\": \"" + gear.getState().name().toLowerCase(Locale.ENGLISH) + "\"");
                    sb.append("\n        }");
                }
            }
            sb.append("\n      ]");
            sb.append("\n    }");
        }
        sb.append("\n  ]");
        sb.append("\n}");
        exchange.getIn().setBody((Object)sb.toString());
    }

    protected void doListPojo(Exchange exchange, IDomain domain) {
        exchange.getIn().setBody((Object)domain.getApplications());
    }

    protected void doStart(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        app.start();
    }

    protected void doStop(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        app.stop();
    }

    protected void doRestart(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        app.restart();
    }

    protected void doState(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        String state = OpenShiftHelper.getStateForApplication(app);
        exchange.getIn().setBody((Object)state);
    }
}

