/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openshift;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IGear;
import com.openshift.client.IGearGroup;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.IUser;
import com.openshift.client.OpenShiftConnectionFactory;
import com.openshift.client.configuration.OpenShiftConfiguration;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import org.apache.camel.component.openshift.OpenShiftEndpoint;

public final class OpenShiftHelper {
    private static final String DEFAULT_OPENSHIFT_SERVER = "openshift.redhat.com";

    private OpenShiftHelper() {
    }

    public static String getOpenShiftServer(OpenShiftEndpoint endpoint) throws IOException {
        String answer = endpoint.getServer();
        if (answer == null) {
            answer = new OpenShiftConfiguration().getLibraServer();
        }
        if (answer == null) {
            answer = DEFAULT_OPENSHIFT_SERVER;
        }
        return answer;
    }

    public static IDomain loginAndGetDomain(OpenShiftEndpoint endpoint, String openshiftServer) {
        IOpenShiftConnection connection = new OpenShiftConnectionFactory().getConnection(endpoint.getClientId(), endpoint.getUsername(), endpoint.getPassword(), openshiftServer);
        IUser user = connection.getUser();
        IDomain domain = endpoint.getDomain() != null ? user.getDomain(endpoint.getDomain()) : user.getDefaultDomain();
        return domain;
    }

    public static String getStateForApplication(IApplication application) {
        for (IGearGroup group : application.getGearGroups()) {
            Iterator i$ = group.getGears().iterator();
            if (!i$.hasNext()) continue;
            IGear gear = (IGear)i$.next();
            String state = gear.getState().name().toLowerCase(Locale.ENGLISH);
            return state;
        }
        return "unknown";
    }
}

